#include "yagstst.h"
#include "screen.h"

void
TestRectangle(AYAGSScreen *graphdev,const U16 left, const U16 top,
	const U16 width, const U16 height)
{
	U16 right = left + width - 1;
	U16 bottom = top + height - 1;
	int looper;
	
	// Clear the area to black
	graphdev->RectFill(left,top,right, bottom,0);
	
	
	
	for (looper=0; looper < 1024; looper++)
	{
		U16 x1 = left + rand()%width;
		U16 y1 = top + rand()%height;
		
		U16 x2 = left + rand()%width;
		U16 y2 = top + rand()%height;
		
		// The RectFill routine expects the coordinates to be
		// in the right order (left,top,right,bottom)
		graphdev->RectFill(
			Y2DMIN(x1,x2), Y2DMIN(y1,y2),
			Y2DMAX(x1,x2), Y2DMAX(y1,y2),
			looper%256);
	}
}

long
TestRectangleThread(void *data)
{
	testParam *tparam = (testParam*)data;
	
	TestRectangle(tparam->fScreenInfo, tparam->fFrame.left,tparam->fFrame.top,
		tparam->fFrame.Width(),tparam->fFrame.Height());
	
	return 0;
}

