
#include "yagstst.h"
#include "random.h"

void 
TestPoint(AYAGSScreen* graphdev, const U16 left, const U16 top, const U16 width, const U16 height)
{
	unsigned char aColor=0;
	U16 right = left + width - 1;
	U16 bottom = top + height - 1;
	
	// Clear the area to black
	graphdev->RectFill(left,top,right, bottom,0);
	

	Random aRand(1);
	for (int looper = 0; looper < 120000; looper++)
	{
		graphdev->SetPixel(aRand.RandomLong()%width, aRand.RandomLong()%height,rand()%256);
	}
	
	Random bRand(1);
	for (int looper = 0; looper < 120000; looper++)
	{
		graphdev->SetPixel(bRand.RandomLong()%width, bRand.RandomLong()%height,0);
	}
	
	for (int looper = 0; looper < 500000; looper++)
	{
		graphdev->SetPixel(rand()%width, rand()%height,rand()%256);
	}
}

long
TestPointThread(void *data)
{
	testParam *tparam = (testParam*)data;
	
	TestPoint(tparam->fScreenInfo, tparam->fFrame.left,tparam->fFrame.top,
		tparam->fFrame.Width(),tparam->fFrame.Height());
	
	return 0;
}

