#include "yagstst.h"

void
TestEllipse(AYAGSScreen* graphdev,const U16 left, const U16 top,
	const U16 width, const U16 height)
{
	U08 aColor=0;
	U16 right = left + width - 1;
	U16 bottom = top + height - 1;
	U16 minor = Y2DMIN(width/2-1,height/2-1);
	
	// Clear the screen to black
	graphdev->RectFill(left,top,right, bottom,0);
	
	//for (int looper=0; looper < 2; looper++)
	//{
		for (int radius = minor; radius > 6 ; radius-=2)
		{
			graphdev->EllipseFill(left+(width/2)-1,top+(height/2)-1, radius*width/height, radius, radius*((height/2)-1)%256);
			gYAGSScreen->Ellipse(left+width/2,top+height/2, ((radius*width)/height)+1, radius+1, 255);
		}
		
	//}

}

long
TestEllipseThread(void *data)
{
	testParam *tparam = (testParam*)data;
	
	TestEllipse(tparam->fScreenInfo, tparam->fFrame.left,tparam->fFrame.top,
		tparam->fFrame.Width(),tparam->fFrame.Height());
	
	return 0;
}


