#ifndef SCREEN_H
#define SCREEN_H

#include <WindowScreen.h>
#include "yags2d.h"
#include "yags3d.h"


class AYAGSScreen : public BWindowScreen
{

public:
				AYAGSScreen(); 
	
	virtual	void	Quit();
	virtual	void	ScreenConnected(bool active);
	virtual void	MessageReceived(BMessage *message);

	// YAGS API Implementation
	inline void SetPixel( const U16 x, const U16 y, const U08 aColor);
	inline void GetPixel( const U16 x, const U16 y, U08 *aColor);
			
	void	HLine(const U16 x1, const U16 y1, const U16 x2, const U16 y2, const U08 aColor);
	void	VLine(const U16 x1, const U16 y1, const U16 x2, const U16 y2, const unsigned char aColor);
	void	Line(const U16 x1, const U16 y1, const U16 x2, const U16 y2, const U08 aColor);
	void	Lines(const Point2Ds *pts, const unsigned long npts, const U08 aColor);
	void	LineStrip(const Point2Ds *pts, const unsigned long npts, const U08 aColor);

	void	Triangle(
			const U16 x1, const U16 y1,
			const U16 x2, const U16 y2,
			const U16 x3, const U16 y3,
			const U08 aColor);
	void	TriangleFill(
			const U16 x1, const U16 y1,
			const U16 x2, const U16 y2,
			const U16 x3, const U16 y3,
			const U08 aColor);
	void	TopTriangleFill(
			const U16 x1, const U16 y1,
			const U16 x2, const U16 y2,
			const U16 x3, const U16 y3,
			const U08 aColor);
	void	BottomTriangleFill(
			const U16 x1, const U16 y1,
			const U16 x2, const U16 y2,
			const U16 x3, const U16 y3,
			const U08 aColor);


	void	Quad(
			const U16 x1, const U16 y1,
			const U16 x2, const U16 y2,
			const U16 x3, const U16 y3,
			const U16 x4, const U16 y4,
			const U08 aColor);
	void	QuadFill(
			const U16 x1, const U16 y1,
			const U16 x2, const U16 y2,
			const U16 x3, const U16 y3,
			const U16 x4, const U16 y4,
			const U08 aColor);

	void	Rect(const U16 left, const U16 top,
			const U16 right, const U16 bottom,
			const U08 aColor);

	void	RectFill(const U16 left, const U16 top,
			const U16 right, const U16 bottom,
			const U08 aColor);

	void	Clear(const U08 aColor);

	void	Polygon(const Point2Ds* pts, const unsigned long npts,
			const U08 aColor);

	void	Ellipse(const U16 x, const U16 y,
			const U16 radiusX, const U16 radiusY, 
			const U08 aColor);

	void	EllipseFill(const U16 x, const U16 y,
			const U16 radiusX, const U16 radiusY, 
			const U08 aColor);

	inline void	Circle(const U16 x, const U16 y,
			const U16 radius, const U08 aColor);

	inline void	CircleFill(const U16 x, const U16 y,
			const U16 radius, const U08 aColor);

	void	CopyPixels( const pixel_buffer src);

	void	CopyPixels(const U16 x1, const U16 y1);

	void	Bezier(const U16 nPts, const Point2Df *pts, 
			const U08 aColor, const U16 iters);

//=======================================================
// 3D Interface
//=======================================================
	void	Line( const Point3Dhf pt1, const Point3Dhf pt2, 
			const U08 aColor, const Camera aCamera);

	void	RenderWireObject(const FacetedObject3D *aObject,
			const U08 aColor, const Camera aCamera);
	
	
//=======================================================
// Instance Variables
//=======================================================
	pixel_buffer fScreen;
	U16 width;
	U16 height;
	U32 bytes_per_row;
	
	void	*pixels;
};


inline void 
AYAGSScreen::SetPixel( const U16 x, const U16 y, const U08 aColor)
{	
	((U08 *)fScreen.pixels)[y * fScreen.bytes_per_row + x] = aColor;
}

// Pixel Getting
//==================================================================
//	Y2DGetPixel
//
//	Assumptions
//	1) The x and y must be within the confines of the pixel_buffer
//==================================================================
inline void 
AYAGSScreen::GetPixel(const U16 x, const U16 y, U08 *aColor)
{	
	*aColor = ((U08 *)fScreen.pixels)[y * fScreen.bytes_per_row + x];
}


inline void
AYAGSScreen::Circle(const U16 x, const U16 y,
			const U16 radius, const U08 aColor)
{
	Ellipse(x, y, radius, radius, aColor);
}

inline void
AYAGSScreen::CircleFill(const U16 x, const U16 y,
			const U16 radius, const U08 aColor)
{
	EllipseFill(x, y, radius, radius, aColor);
}

extern AYAGSScreen *gYAGSScreen;

#endif
