#ifndef EFFECTS_H
#define EFFECTS_H

#include "yags2d.h"
#include "screen.h"

// Dissolves and fades
void
Y2DEffectFadeToBlack(AYAGSScreen&, const U08 steps);

void
Y2DEffectFadeToWhite(AYAGSScreen&, const U08 steps);

void
Y2DEffectRandomDissolve(AYAGSScreen&, const BRect frame, U08 aColor);

void
Y2DEffectBarnOpen(AYAGSScreen&, const U16 left, const U16 top, const U16 width, const U16 height, U08 aColor, const int delay=100);

void
Y2DEffectBarnClose(AYAGSScreen&, const BRect frame, U08 aColor, const int delay=100);


// Generic Wipes
void
Y2DEffectWipeFromLeft(AYAGSScreen&, const U16 left, const U16 top, const U16 width, const U16 height, U08 aColor, const int delay=100);

void
Y2DEffectWipeFromRight(AYAGSScreen&, const U16 left, const U16 top, const U16 width, const U16 height, U08 aColor, const int delay=100);

void
Y2DEffectWipeFromBottom(AYAGSScreen&, const U16 left, const U16 top, const U16 width, const U16 height, U08 aColor, const int delay=100);

void
Y2DEffectWipeFromTop(AYAGSScreen&, const U16 left, const U16 top, const U16 width, const U16 height, U08 aColor, const int delay=100);


// Pixel effects
void
Y2DEffectPixelRain(AYAGSScreen&, const pixel_buffer source, const int delay = 0); 

void
Y2DEffectRipple(AYAGSScreen&); 


#endif
