#include "effects.h"
#include "screen.h"

#include <stdlib.h>

//=======================================================
// Function: FadeToBlack
//
// Fads the entire image to black.
//=======================================================
void
Y2DEffectFadeToBlack(AYAGSScreen& scrInfo, const U08 steps)
{
	U16 width = scrInfo.width;
	U16 height = scrInfo.height;
	U08 aColor;
	rgb_color rgb;
	U08 dSteps = 256/steps;
	
	//
	for (int i = 0; i < steps; i++)
	{
		for (int counter = 0; counter < 256; counter++)
		{
			// Set each value in the color palette
			rgb = system_colors()->color_list[counter];
		
			// decrease the value by dSteps
			if (rgb.red >= dSteps)
				rgb.red -= dSteps;
			else 
				rgb.red = 0;
					 
			if (rgb.green >= dSteps)
				rgb.green -= dSteps;
			else 
				rgb.green = 0;

			if (rgb.blue >= dSteps)
				rgb.blue -= dSteps;
			else 
				rgb.blue = 0;
			
			system_colors()->color_list[counter] = rgb;
		}
#if 0
		// For each row
		for (U16 row = 0; row < height; row++)
		{
			U08 *base = &((U08*)scrInfo.bits)[row*scrInfo.bytes_per_row];
			// for each column
			for (U16 column = 0; column < width; column++)
			{
				// get the pixel
				//Y2DGetPixel(scrInfo,column, row, aColor);
				aColor = *base;
				if (aColor > 0)
					aColor--;
/*
				// change to rgb
				rgb = system_colors()->color_list[aColor];
				
				// decrease the value by dSteps
				if (rgb.red >= dSteps)
					rgb.red -= dSteps;
				else 
					rgb.red = 0;
					 
				if (rgb.green >= dSteps)
					rgb.green -= dSteps;
				else 
					rgb.green = 0;

				if (rgb.blue >= dSteps)
					rgb.blue -= dSteps;
				else 
					rgb.blue = 0;
					
				// convert back to U08
				aColor = index_for_color(rgb);
*/				
				// set the pixel
				//Y2DSetPixel(scrInfo, column, row, aColor);
				*base = aColor;
				base++;
			}
		}
#endif
	}
}

void
Y2DEffectFadeToWhite(AYAGSScreen& scrInfo, const U08 steps)
{

}

void
Y2DEffectRandomDissolve(AYAGSScreen& scrInfo, const BRect frame, U08 aColor)
{
	U16 width = frame.Width();
	U16 height = frame.Height();
	float x, y;
	U16 x1;
	U16 y1;
	
	srand(1);
	for (int looper = 0; looper < 2000000; looper++)
	{
		x = ((float)rand()/(float)RAND_MAX)*width;
		y = ((float)rand()/(float)RAND_MAX)*height;
		scrInfo.SetPixel((U16)x, (U16)y,aColor);
	}
}


void
Y2DEffectBarnOpen(AYAGSScreen& scrInfo, const U16 left, const U16 top, const U16 width, const U16 height, U08 aColor, const int delay)
{
	U16 right = left + width -1;
	U16 bottom = top + height - 1;
	
	int midx = width/2;
	int midy = height/2;
	int deltax = width/2;
	int deltay = height/2;
	int deltamin = Y2DMIN(deltax,deltay);
	int dx = deltax/deltamin;
	int dy = deltay/deltamin;
	
	// Draw succesive lines like a barn door opening
	for (int i = 0; i<deltax; i++)
	{
		scrInfo.VLine(midx-i,top,midx-i,bottom,aColor);
		scrInfo.VLine(midx+i,top,midx+i,bottom,aColor);
		snooze(delay);
	}
}


void
Y2DEffectBarnClose(AYAGSScreen& scrInfo, const BRect frame, U08 aColor, const int delay)
{
	U16 width = frame.Width();
	U16 height = frame.Height();
	
	int midx = width/2;
	int midy = height/2;
	int deltax = width/2;
	int deltay = height/2;
	int deltamin = Y2DMIN(deltax,deltay);
	int dx = deltax/deltamin;
	int dy = deltay/deltamin;
	
	// Draw succesive lines like a barn door closing
	for (int i = deltax; i>=0; i--)
	{
		// Draw Rectangle centered on middle of screen
		scrInfo.VLine(midx-i,frame.top,midx-i,frame.bottom,aColor);
		scrInfo.VLine(midx+i,frame.top,midx+i,frame.bottom,aColor);
		snooze(delay);
	}
}


void
Y2DEffectWipeFromLeft(AYAGSScreen& scrInfo, const U16 left, const U16 top, const U16 width, const U16 height, U08 aColor, const int delay)
{
	U16 bottom = top + height - 1;	
	
	// Draw succesive lines moving from left to right
	for (int i = 0; i<=width; i++)
	{
		// Draw Rectangle centered on middle of screen
		scrInfo.VLine(left+i,top,left+i,bottom,aColor);
		snooze(delay);
	}
}

void
Y2DEffectWipeFromRight(AYAGSScreen& scrInfo, const U16 left, const U16 top, const U16 width, const U16 height, U08 aColor, const int delay)
{
	U16 bottom = top + height - 1;
	
	// Draw succesive lines moving from left to right
	for (int i = width; i>=0; i--)
	{
		// Draw Rectangle centered on middle of screen
		scrInfo.VLine(left+i,top,left+i,bottom,aColor);
		snooze(delay);
	}
}


void
Y2DEffectWipeFromBottom(AYAGSScreen& scrInfo, const U16 left, const U16 top, const U16 width, const U16 height, U08 aColor, const int delay)
{
	U16 right = left + width -1;
	U16 bottom = top + height - 1;
	
	// Draw succesive lines like a barn door closing
	for (int i = height; i>=0; i--)
	{
		// Draw Rectangle centered on middle of screen
		scrInfo.HLine(left,top+i,right,top+i,aColor);
		snooze(delay);
	}
}


void
Y2DEffectWipeFromTop(AYAGSScreen& scrInfo, const U16 left, const U16 top, const U16 width, const U16 height, U08 aColor, const int delay)
{
	U16 right = left + width -1;
	
	// Draw succesive lines like a barn door closing
	for (int i = 0; i<=height; i++)
	{
		// Draw Rectangle centered on middle of screen
		scrInfo.HLine(left,top+i,right,top+i,aColor);
		snooze(delay);
	}
}


//==================================================================
// Function:  Y2DEffectPixelRain
//
// This effect takes a line at a time from the source image and
// pulls it down from the top to the rest at the bottom.  The pixels
// are not erased as they are drawn, so they streak the screen.
//==================================================================
void
Y2DEffectPixelRain(AYAGSScreen& scrInfo, const pixel_buffer source, const int delay)
{
	U16 dstwidth = scrInfo.width;
	U16 dstheight = scrInfo.height;
	U16 srcwidth = source.width;
	U16 srcheight = source.height;
	U08 *srcRowPtr;
	U16 y=srcheight-1, x=0;
	
	//printf("Destination: %d %d\n",dstwidth, dstheight);
	//printf("Source: %d %d %d\n",srcwidth, srcheight, source.bytes_per_row);
	
	// For each row in the source buffer
	for (y = srcheight-1; (y>0); y--)
	{
		//printf("Y: %d DestHeight: %d\n",y, dstheight);
		// Get the pointer the row of pixels
		srcRowPtr = &((U08*)source.pixels)[y*source.bytes_per_row+x];

		// for each row in the destination
		// Call the pixel span routine to draw the line
		// of pixels.
		for (int row = 0; row < dstheight; row++)
		{
			//scrInfo.PixelSpan(0, row, srcRowPtr, srcwidth-1);
			snooze(delay);
		}
	
		dstheight--;
	}
}


void
Y2DEffectRipple(AYAGSScreen& scrInfo)
{
	U16 width = scrInfo.width;
	U16 height = scrInfo.height;
	
	for (U16 y=1; y < height; y++)
	{
		for (U16 x=1; x < width; x++)
		{
			U08 aColor; 
			U16 newY = y+1.5*sin(1.5*(y+x));
			scrInfo.GetPixel(x, newY, &aColor);
			scrInfo.SetPixel(x, y, aColor);
		}
	}
}
