#include "yags2d.h"
#include <string.h>

//=================================================================
// Function: InLimits
//
// This function simply tests to make sure the x and Y coordinates
// are within the bounds of the pixel_buffer object.  It assumes that
// the pixel_buffer represents something with its origin at 0,0
//=================================================================

inline bool
Y2DInLimits(pixel_buffer screenInfo, unsigned short x, unsigned short y)
{
	return  ((x <= screenInfo.width) && (y <= screenInfo.height));
}


//=================================================================
// Function: Y2DPoints
//
// Set an array of points to the given color value, 
//=================================================================

void
Y2DPoints(pixel_buffer screenInfo,
	const Point2Ds *pts, const unsigned long npts, 
	const unsigned char aColor)
{
	for (int counter =0; counter < npts; counter++)
	{
		// If the given pixel is within the limits
		// then set it to the specified color.
		if (Y2DInLimits(screenInfo, pts[counter].x,pts[counter].y))
			Y2DSetPixel(screenInfo, pts[counter].x,pts[counter].y,aColor);
	}	
}




/*
typedef enum  {
	// Single Primitives
	Y2D_POINT = 1,
	Y2D_LINE,
	Y2D_TRIANGLE,
	Y2D_RECTANGLE,
	Y2D_POLYGON,
	Y2D_CIRCLE,
	Y2D_ELLIPSE,
	Y2D_ARC,
	
	// Disjoint, multiple primitives
	Y2D_POINTS,
	Y2D_LINES,
	Y2D_TRIANGLES,
	Y2D_RECTANGLES,
	Y2D_POLYGONS,
	Y2D_ELLIPSES,
	Y2D_ARCS,
		
	Y2D_LINESTRIP,
	Y2D_LINELOOP,
	Y2D_TRIANGLESTRIP,
	Y2D_TRIANGLEFAN
} YAGS2DPOINTPRIM;
 */

//=================================================================
// Function: Y2DPrimitives
//
// This is the big bottleneck routine that coalesces all the drawing
// primitives into one spot.  As long as you have a framebuffer
// represented by the screenInfo object, and a drawing primitive.
// You should be able to draw anything you like using only this
// high level routine.
//
// This routine makes it convenient to implement remote drawing methods.
// all you have to do on the sending side is package up the points
// and send them to their destination with the intended drawing
// primitive.
//=================================================================

void	
Y2DPrimitives(pixel_buffer screenInfo, 
	YAGS2DPOINTPRIM drawingPrimitive, 
	const Point2Ds* pts, 
	const unsigned long npts,
	const unsigned char aColor)
{
	switch (drawingPrimitive)
	{
		case Y2D_POINT:
			Y2DSetPixel(screenInfo, pts[0].x, pts[0].y, aColor);
		break;
		
		case Y2D_LINE:
			Y2DLine(screenInfo, pts[0].x, pts[0].y, pts[1].x, pts[1].y, aColor);

		case Y2D_TRIANGLE:
			Y2DTriangle(screenInfo,pts[0].x, pts[0].y, pts[1].x, pts[1].y, pts[2].x, pts[2].y, aColor);
		break;
		
		case Y2D_RECTANGLE:
			Y2DRect(screenInfo,pts[0].x, pts[0].y, pts[1].x, pts[1].y, aColor);
		break;
		
		case Y2D_ARC:
		break;
		
		case Y2D_CIRCLE:
			Y2DCircle(screenInfo,pts[0].x, pts[0].y, pts[1].x, aColor);
		break;
		
		case Y2D_POLYGON:
			Y2DPolygon(screenInfo, pts, npts, aColor);
		break;
		
		case Y2D_ELLIPSE:
			Y2DEllipse(screenInfo,pts[0].x, pts[0].y, pts[1].x, pts[1].y, aColor);
		break;
		
		
		// Multiple primitives
		case Y2D_POINTS:
			Y2DPoints(screenInfo,pts, npts,aColor);
		break;
		
		case Y2D_LINES:
			Y2DLines(screenInfo,pts, npts,aColor);
		break;
	}	
}

