#include "yags2d.h"
#include <stdlib.h>
#include <string.h>


void
Y2DTriangle(pixel_buffer screenInfo,
	const U16 x1, const U16 y1,
	const U16 x2, const U16 y2,
	const U16 x3, const U16 y3,
	const U08 aColor)
{
 	// Use the line drawing routine to draw the sides.
	// Ideally we would have an explicit Y2DVLine and Y2DHLine
	// to optimize drawing horizontal and vertical lines.
	
	Y2DLine(screenInfo, x1,y1,x2,y2, aColor); 
	Y2DLine(screenInfo, x2,y2,x3,y3, aColor); 
	Y2DLine(screenInfo, x3,y3,x1,y1, aColor); 
}

void
Y2DTopTriangleFill(pixel_buffer scrInfo,
	const U16 x1, const U16 y1,
	const U16 x2, const U16 y2,
	const U16 x3, const U16 y3,
	const U08 aColor)
{
	float dx_right;
	float dx_left;
	float xs;
	float xe;
	
	float X1=x1, X2=x2, X3=x3;
	float Y1=y1, Y2=y2, Y3=y3;
	
	float height;
	int temp_x;
	int temp_y;
	
	if (X2 < X1)
	{
		temp_x = X2;
		X2 = X1;
		X1 = temp_x;
	}
	
	// compute deltas
	height = Y3 - Y1+1;
	
	dx_left = (X3-X1)/height;
	dx_right = (X3-X2)/height;
	
	// set starting points
	xs = (float)X1;
	xe = (float)X2+(float)0.5;
	
#if 0
	// We won't bother with clipping now
	// But here's the code that should go somewhere
	// perform clipping
#endif

	// Start drawing the lines
	for (temp_y = Y1; temp_y <= Y3; temp_y++)
	{
		Y2DHLine(scrInfo, (U16)xs, (U16)temp_y, (U16)xe, (U16)temp_y, aColor);
		
		xs += dx_left;
		xe += dx_right;
	}
}

void
Y2DBottomTriangleFill(pixel_buffer scrInfo,
	const U16 x1, const U16 y1,
	const U16 x2, const U16 y2,
	const U16 x3, const U16 y3,
	const U08 aColor)
{
	float dx_right;
	float dx_left;
	float xs;
	float xe;
	
	float X1=x1, X2=x2, X3=x3;
	float Y1=y1, Y2=y2, Y3=y3;
	
	float height;
	int temp_x;
	int temp_y;
	int deltaX;
	int deltaY;
	
	if (X3 < X2)
	{
		temp_x = X2;
		X2 = X3;
		X3 = temp_x;
	}
	
	// compute deltas
	height = Y3 - Y1+1;
	
	dx_left = (X2-X1)/height;
	dx_right = (X3-X1)/height;
	
	// set starting points
	xs = (float)X1;
	xe = (float)X1+(float)0.5;
	
#if 0
	// We won't bother with clipping now
	// But here's the code that should go somewhere
	// perform clipping
#endif

	// Start drawing the lines
	for (temp_y = Y1; temp_y <= Y3; temp_y++)
	{
		deltaX = xe - xs;
		if (deltaX > 0)
			Y2DHLine(scrInfo, (U16)xs, (U16)temp_y, (U16)xe, (U16)temp_y, aColor);
		
		xs += dx_left;
		xe += dx_right;
	}
}

void	
Y2DTriangleFill(pixel_buffer scrInfo,
	const U16 x1, const U16 y1,
	const U16 x2, const U16 y2,
	const U16 x3, const U16 y3,
	const U08 aColor)
{
	int temp_x, temp_y;
	int new_x;
	
	U16 X1=x1, X2=x2, X3=x3;
	U16 Y1=y1, Y2=y2, Y3=y3;
	
	// test for h lines and v lines
	if ((X1==X2) && (X2==X3))
	{
		// Vertical line
		Y2DVLine(scrInfo,X1,Y1,X1,Y3,aColor);
		return;
	}
	
	if  ((Y1==Y2) && (Y2==Y3))
   	{
		// Horizontal Line
		Y2DHLine(scrInfo,X1,Y1,X3,Y1,aColor);
		return;
	}
	
	// sort p1,p2,p3 in ascending y order
	if (Y2<Y1)
	{
		temp_x = X2;
		temp_y = Y2;
		X2     = X1;
		Y2     = Y1;
		X1     = temp_x;
		Y1     = temp_y;
	} // end if

	// now we know that p1 and p2 are in order
	if (Y3<Y1)
	{
		temp_x = X3;
		temp_y = Y3;
		X3     = X1;
		Y3     = Y1;
		X1     = temp_x;
		Y1     = temp_y;
	} // end if

	// finally test y3 against y2
	if (Y3<Y2)
	{
		temp_x = X3;
		temp_y = Y3;
		X3     = X2;
		Y3     = Y2;
		X2     = temp_x;
		Y2     = temp_y;
	} // end if

	// do trivial rejection tests

	//if ( Y3<scrInfo.top || Y1>scrInfo.frame.bottom ||
    //	(X1<scrInfo.frame.left && X2<scrInfo.frame.left && X3<scrInfo.frame.left) ||
    //	(X1>scrInfo.frame.right && X2>scrInfo.frame.right && X3>scrInfo.frame.right) )
	//	return;
	// test if top of triangle is flat
	if (Y1==Y2)
	{
		Y2DTopTriangleFill(scrInfo, X1,Y1, X2,Y2, X3,Y3, aColor);
	} else
	if (Y2==Y3)
	{
		Y2DBottomTriangleFill(scrInfo, X1,Y1, X2,Y2, X3,Y3, aColor);
	} else
	{
		// general triangle that needs to be broken up along long edge
		new_x = X1 + (int)((float)(Y2-Y1)*(float)(X3-X1)/(float)(Y3-Y1));

		// draw each sub-triangle
		Y2DBottomTriangleFill(scrInfo, X1,Y1,new_x,Y2,X2,Y2,aColor);
		Y2DTopTriangleFill(scrInfo, X2,Y2,new_x,Y2,X3,Y3,aColor);
   } // end else
}


