#include "lib.h"

/* Imported function declaration */
void bezier( Flt p[], int segments, int div, Flt output[] ) ;

/* number of points in control polygon */
/* M must be of form k*3+1 */
#define  K   ( 2)
#define  M   (K*3+1)
#define DIV  (10)
/* number of points in approximating polygon */
#define  N   (K*DIV+1)

/* Control polygon initialization */
Flt xp[M] = { 0.295, 0.705, 0.266, 0.206, 0.172, 0.508, 0.608 } ;
Flt yp[M] = { 0.154, 0.283, 0.413, 0.580, 0.816, 0.745, 0.515 } ;
/* Declaration of output arrays */
Flt ox[N], oy[N] ;

void main( void )
{
    /* calculate spline */
    bezier( xp, K, DIV, ox ) ;
    bezier( yp, K, DIV, oy ) ;
    /* initialize graphics mode */
    SetVideoMode() ;
    /* display control polygon */
    DrawPolygon( xp, yp, M, 1 ) ;
    /* display built approximating polygon */
    DrawPolygon( ox, oy, N, 2 ) ;
}

