#include "common.h"

Flt bezier_3( Flt p[4], Flt t )
{
    Flt s = 1 - t ;
    Flt t2 = t*t ;
    Flt t3 = t2 * t ;
    return ((s*p[0] + 3*t*p[1])*s + 3*t2*p[2])*s + t3*p[3] ;
}

/*
**  Syntax: bezier( p, segments, div, output )
**
**          Flt p[]         (in)    - control polygon of Bezier curve
**                                    elements p[0] .. p[ m-1 ]
**                                    where m = 3*segments+1
**          int segments    (in)    - number of segments in Bezier curve
**          int div         (in)    - number of links in approximating
**                                    polygon
**          Flt output[]    (out)   - approximating polygon
**                                    elements output[0] .. output[k-1]
**                                    where k = segments*div+1
*/
void bezier( Flt p[], int segments, int div, Flt output[] )
{
    Flt t, dt = 1.0 / div ;
    int s, d, first = 0 ;

    for( s = 0; s < segments; s ++ )
    {
        t = 0 ;
        for( d = 0; d <= div; d ++ )
        {
            output[ first + d ] = bezier_3( &p[ s*3 ], t ) ;
            t += dt ;
        }
        first += div ;
    }
}

