#include "yags2d.h"
#include <stdio.h>

/*
	Bezier Curve drawing
*/

static void
BezierForm(const U16 NumCtlPoints, const Point2Df *p, BezArray c)
{
	int k;
	long n=NumCtlPoints-1;
	long choose;
	
	for (k=0; k<= n; k++)
	{
		if (k==0)
			choose = 1;
		else if (k==1)
			choose = n;
		else
			choose = choose *(n-k+1)/k;
		
		c[k].x = p[k].x * choose;
		c[k].y = p[k].y * choose;
	}
}

static void
BezierCurve(const int NumCtlPoints, BezArray c, Point2Df *pt, const float t)
{
	int n = NumCtlPoints-1;
	int k;
	float t1, tt;
	float u =t;
	BezArray b;
	
	b[0].x = c[0].x;
	b[0].y = c[0].y;
	
	for (k=1; k<= n; k++)
	{
		b[k].x = c[k].x * u;
		b[k].y = c[k].y * u;
		u = u*t;
	}
	
	(*pt).x = b[n].x;
	(*pt).y = b[n].y;
	t1 = 1-t;
	tt = t1;
	
	for (k=n-1; k>=0; k--)
	{
		(*pt).x += b[k].x * tt;
		(*pt).y += b[k].y * tt;
		tt = tt*t1;
	}
}

void	
Y2DBezier(const U16 nPts, const Point2Df *pts, const U08 aColor, const U16 iters, pixel_buffer scrInfo)
{
	BezArray bc;
	Point2Df pt;
	Point2Df lastPoint;
	int k;
	
	BezierForm(nPts, pts, bc);
	
	for (k=0; k<=iters; k++)
	{
		BezierCurve(nPts, bc, &pt, (float)k/(float)iters);
		
		// Draw the line segment
		if (k==0)
		{
			lastPoint.x = pt.x;
			lastPoint.y = pt.y;
		} else
		{
			//printf("%3d %8.2f %8.2f\n", k, pt.x, pt.y);
			//Y2DLine(scrInfo, lastPoint.x, lastPoint.y,
			//	pt.x, pt.y, 200);
			Y2DLineBres(lastPoint.x, lastPoint.y,pt.x, pt.y, 
				aColor,scrInfo);
				
			lastPoint.x = pt.x;
			lastPoint.y = pt.y;
		}	
	}
}

