#include "yagstest.h"

void
TestTriangle(pixel_buffer scrInfo, const U16 left, const U16 top,
	const U16 width, const U16 height)
{
	unsigned char aColor=0;
	U16 right = left + width -1;
	U16 bottom = top + height - 1;
	long counter1, counter2;
	long looper;
	
	// Clear the area to black
	//Y2DRectFill(scrInfo,left,top,right, bottom,0);
	
	//Y2DPrimitives(scrInfo, Y2D_TRIANGLE, pts, npts, aColor);

	// Bottom Triangles
	//Y2DLine(scrInfo, 100,100,10,150, 25); 
	//Y2DLine(scrInfo, 10,150,60,200, 23); 
	//Y2DLine(scrInfo, 60,200,100,100, 25); 

	//Y2DTriangle(scrInfo, 100,100,  10,150,  60,200,  25);
	//Y2DTriangle(scrInfo, 120,20,  15,160,  100,190,  25);
	//Y2DTriangleFill(scrInfo, 100,100,  10,150,  60,200,  23);

	//return;
	for (int looper = 0; looper < 1; looper++)
	{
		for (counter1 = (width/2); counter1 > 0; counter1 -= 1)
		{
			// Bottom Triangles
			//Y2DTriangle(scrInfo,
			Y2DTriangleFill(scrInfo,
				left+width/2,bottom-counter1,
				left+width/2 - counter1,bottom,
				left+width/2 + counter1,bottom,
				(counter1 % 255));
			
			// Top Triangles
			Y2DTriangleFill(scrInfo,
				left+width/2,bottom/2,
				left+(width/2)-((width/2)-counter1),top+counter1-1,
				left+(width/2)+(width/2)-counter1,top+counter1-1,
				rand() % 256);
		}

		for (counter2 = (height/2); counter2 > 0; counter2-=1)
		{
			// Left Triangles
			Y2DTriangleFill(scrInfo,
				left+width/2,top+(height/2),
				left+0,top+(height/2)-counter2,
				left+0,top+(height/2)+counter2,
				counter2 % 256);

			// Right Triangles
			Y2DTriangleFill(scrInfo,
				left+width/2,top+(height/2),
				left+width,top+(height/2)-counter2,
				left+width,top+(height/2)+counter2,
				counter2 % 256);
		}
	}

/*	// Do some random triangles
	double newtime = 0.0;
	double lasttime = system_time();
	double interval = 0.0;
	
	srand(1);
	for (int looper = 0; looper < 1024; looper++)
	{
		U16 x1 = left+rand()%width;
		U16 y1 = top+rand()%height;
		U16 x2 = left+rand()%width;
		U16 y2 = top+rand()%height;
		U16 x3 = left+rand()%width;
		U16 y3 = top+rand()%height;
		
		//Y2DTriangle(scrInfo,
		//	x1, y1,
		//	x2, y2,
		//	x3, y3,
		//	rand()%255);
		Y2DTriangleFill(scrInfo,
			x1, y1,
			x2, y2,
			x3, y3,
			rand()%255);
			
		//newtime = system_time();
		//interval = newtime - lasttime;
		//lasttime = newtime;
		//printf("%6.2f %3d %3d %3d\t %3d %3d %3d\n",(interval/1000), x1,x2,x3,y1,y2,y3);
	}	
*/
}

long
TestTriangleThread(void *data)
{
	testParam *tparam = (testParam*)data;
	
	TestTriangle(tparam->fScreenInfo, 
		tparam->fFrame.left,tparam->fFrame.top,
		tparam->fFrame.Width(),tparam->fFrame.Height());
	
	return 0;
}


