/* lbjtest.cpp

Source example for edmidi:
	1. Compile this file (we'll call the executable 'LbjTest').
	2. Run test and capture the output:
		$ LbjTest > test1.lbj
	3. Run test1.lbj through edmidi:
		$ edmidi test1.lbj
*/

#include "langMacros.h"
#include "pitches.h"
#include <stdio.h>
#include <stdlib.h>
/* We need this for the instrument constants. */
#include <MidiDefs.h> 

/* Handy timing jitter */
#define rnd ((rand()%1000)*.00002)

main()
{
	/* I like to keep lots of counters around. */
	int ktr, ktr1, ktr2, ktr3;

	/* Record midi data in... */
	Xfile("test.midi");

	/* Tell edmidi to play the data. */
	Xplay();

	/* IMPORTANT:  All floating point values must be cast as fp.
	 * The macros don't convert for you, so be sure to throw 
	 * a decimal in somewhere. 
	 */
	 
	/* Set the tempo (bpm) */
	Xpulse(1.0);

	/* Rest all amp, skew, and mod settings in case we're
	 * going to concatenate lbj files.
	 */
	for (ktr = 1; ktr < 17; ktr++) {
		Xchannel(ktr);
		Xamp(1.0);
		Xskew(0.0);
		Xmod(0.0);
	}

	/* Xchannel() resets time, and redirects subsequent
	 * macro output to the designated channel.
	 */
	Xchannel(1);
	/* Reset the timer to 1.0 (in pulse quanta) */
	Xabs(1.0);
	
	/* Left channel */
	Xpan(-1.0);
	Xvoice(B_REVERSE_CYMBAL);

	/* Generate some random notes; note that since we reset the timer
	 * each time, the notes don't have to be in order. 
	 */
	for (ktr1 = 0; ktr1 < 100; ktr1++) {
		Xabs(1.5);
		Xinc((rand()%100)/5.0);

		/* Xnote(keynum, duration, amp (0.0, 1.0), note_off_amp);
		 * The note_off_amp isn't used by the GM synth.
		 */
		Xnote((rand()%30)+40, (rand()%100)/40.0+.2,  
			((rand()%100)/200.0)+.3, 0.);
	}
	/* Now let's change channels, strum an oboe, and bend it. */
	Xchannel(2);
	int32 notes[] = {c3, g3, c4, ef4, g4, c5};

	/* Reset the timer to 1.0 (in pulse quanta) */
	Xabs(1.0);
	
	/* Right channel */
	Xpan(1.0);

	/* Set the voice. */
	Xvoice(B_OBOE);
	
	/* Generate a chord. The Xtwid() macro bumps the "local" time counter.
	 * Specifically, it bumps time forward without incrementing the
	 * Xinc() counter.  This is particularly useful for
	 * situations (not that this is really one of them) 
	 * in which you need to keep strict time 
	 * between events (where time is kept through Xinc()) but in which
	 * each event is made up of a bunch of little notes (where the 
	 * time between notes is kept through Xtwid()).
	 */
	for (ktr1 = 0; ktr1 < 6; ktr1++) {
		Xnote(notes[ktr1], 20.0, .75, 0.);
		Xtwid(.065); 
	}

	/* Now we're going to apply the amp and pitch bend envelopes.
	 * We'll reset the timer before each envelope so we don't have
	 * to sort out the timing ourselves.
	 */
	Xabs(1.0);
	
	/* After a couple of beats, start a slow fade out*/
	Xinc(2.0); 
	XampA(1.0);

	/* Now finish the fade after 4 more beats. */
	Xinc(14.0);
	XampZ(0.0);
	
	/* Reset the timer and apply a roller coaster pitch bend env. */

	Xabs(1.0);
	Xinc(1.0); 

	/* Start the envelope; we'll finish and restart inside the loop. */
	XskewA(0.0);
	
	float skewAmt;
	for (ktr1 = 2; ktr1 <= 20; ktr1++) {
		Xinc(1.0);

		/* bend within a whole step above and below. */
		skewAmt = ((rand()%100)/25.0)-2.0;
		XskewZ(skewAmt);
		XskewA(skewAmt);
	}		
	/* Finish the last envelope; not entirely necessary, but edmidi is 
	 * happier this way.
	 */
	Xinc(0.1);
	XskewZ(-1.0);	

}
		
