//--------------------------------------------------------------------
//	
//	Status.cpp
//
//	Written by: Robert Polic
//	
//	Copyright 1997 Be, Inc. All Rights Reserved.
//	
//--------------------------------------------------------------------

#pragma once
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "Mail.h"
#include "Status.h"


//====================================================================

TStatusWindow::TStatusWindow(BRect rect, BWindow *window, char *status)
			  :BWindow(rect, "", B_MODAL_WINDOW, B_NOT_RESIZABLE)
{
	BRect		r;

	r.Set(0, 0, STATUS_WIDTH, STATUS_HEIGHT);
	r.InsetBy(-1, -1);
	r.bottom--;
	fView = new TStatusView(r, window, status);
	Lock();
	AddChild(fView);
	Unlock();
	Show();
}


//====================================================================

TStatusView::TStatusView(BRect rect, BWindow *window, char *status)
			:BBox(rect, "", B_FOLLOW_ALL, B_WILL_DRAW)
{
	BFont		font = *be_plain_font;
	rgb_color	c;

	fWindow = window;
	fString = status;

	c.red = c.green = c.blue = VIEW_COLOR;
	SetViewColor(c);
	font.SetSize(FONT_SIZE);
	SetFont(&font);
}

//--------------------------------------------------------------------

void TStatusView::AttachedToWindow(void)
{
	BButton		*button;
	BFont		font = *be_plain_font;
	BRect		r;

	r.Set(STATUS_FIELD_H, STATUS_FIELD_V,
		  STATUS_FIELD_WIDTH,
		  STATUS_FIELD_V + STATUS_FIELD_HEIGHT);
	fStatus = new BTextControl(r, "", STATUS_TEXT, fString,
							new BMessage(STATUS));
	AddChild(fStatus);
	font.SetSize(FONT_SIZE);
	fStatus->SetFont(&font);
	fStatus->SetDivider(StringWidth(STATUS_TEXT) + 6);
	fStatus->BTextControl::MakeFocus(TRUE);

	r.Set(CANCEL_BUTTON_H, CANCEL_BUTTON_V,
		  CANCEL_BUTTON_H + BUTTON_WIDTH,
		  CANCEL_BUTTON_V + BUTTON_HEIGHT);
	button = new BButton(r, "", CANCEL_BUTTON_TEXT, new BMessage(CANCEL));
	AddChild(button);
	button->SetTarget(this);

	r.Set(OK_BUTTON_H, OK_BUTTON_V,
		  OK_BUTTON_H + BUTTON_WIDTH,
		  OK_BUTTON_V + BUTTON_HEIGHT);
	button = new BButton(r, "", OK_BUTTON_TEXT, new BMessage(OK));
	AddChild(button);
	button->SetTarget(this);

	button->MakeDefault(TRUE);
}

//--------------------------------------------------------------------

void TStatusView::MessageReceived(BMessage *msg)
{
	BMessage	*message;

	switch (msg->what) {
		case STATUS:
			break;

		case OK:
			message = new BMessage(M_CLOSE_CUSTOM);
			message->AddString("status", fStatus->Text());
			fWindow->PostMessage(message);
			// will fall through
		case CANCEL:
			Window()->Quit();
			break;
	}
}
