/* ++++++++++

   FILE:  HP_Setup.h
   REVS:  $Revision: 1.4 $
   NAME:  Robert Polic

   Copyright (c) 1996 by Be Incorporated.  All Rights Reserved.

+++++ */

#ifndef HP_SETUP_H
#define HP_SETUP_H

#ifndef _ALERT_H
#include <Alert.h>
#endif
#ifndef _BITMAP_H
#include <Bitmap.h>
#endif
#ifndef _BUTTON_H
#include <Button.h>
#endif
#ifndef _LOOPER_H
#include <Looper.h>
#endif
#ifndef _MESSAGE_FILTER_H
#include <MessageFilter.h>
#endif
#ifndef _MENU_FIELD_H
#include <MenuField.h>
#endif
#ifndef _MENU_ITEM_H
#include <MenuItem.h>
#endif
#ifndef _MESSAGE_H
#include <Message.h>
#endif
#ifndef _POINT_H
#include <Point.h>
#endif
#ifndef _POP_UP_MENU_H
#include <PopUpMenu.h>
#endif
#ifndef _RECT_H
#include <Rect.h>
#endif
#ifndef _TEXT_CONTROL_H
#include <TextControl.h>
#endif
#ifndef _VIEW_H
#include <View.h>
#endif
#ifndef _WINDOW_H
#include <Window.h>
#endif

#include <PrintBits.h>

#define	SETUP_WIDTH			360
#define SETUP_HEIGHT		164

#define	MENU_HEIGHT			 16

#define PAPER_H				 17
#define PAPER_V				 12
#define PAPER_TEXT			"Page Size"
enum	PAPER_SIZE			{PAGE_LETTER = 100, PAGE_LEGAL, PAGE_A4, PAGE_B5,
							 PAGE_TABLOID, PAGE_LEDGER, PAGE_ENVELOPE,
							 PAGE_OTHER};

typedef struct {
	char	name[32];
	float	width;
	float	height;
	long	message;
} PAGESIZE;

PAGESIZE	sizes[] =		{{"US Letter", 8.5, 11.0, PAGE_LETTER},
							 {"US Legal", 8.5, 14.0, PAGE_LEGAL},
							 {"A4", 8.264, 11.694, PAGE_A4},
							 {"B5", 7.167, 10.125, PAGE_B5},
							 {"Tabloid", 11.0, 17.0, PAGE_TABLOID},
							 {"Ledger", 17.0, 11.0, PAGE_LEDGER},
							 {"Envelope", 9.5, 4.125, PAGE_ENVELOPE},
							 {"Other", 0.0, 0.0, PAGE_OTHER}};

#define WIDTH_H				 38
#define WIDTH_V				 40
#define WIDTH_WIDTH			 90
#define WIDTH_HEIGHT		 16
#define WIDTH_TEXT			"Width"

#define HEIGHT_H			(WIDTH_H + WIDTH_WIDTH + 10)
#define HEIGHT_V			WIDTH_V
#define HEIGHT_WIDTH		WIDTH_WIDTH
#define HEIGHT_HEIGHT		WIDTH_HEIGHT
#define HEIGHT_TEXT			"Height"

#define	SCALE_H				 33
#define SCALE_V				 66
#define SCALE_WIDTH			 95
#define SCALE_HEIGHT		WIDTH_HEIGHT
#define SCALE_TEXT			"Scaling"

enum	SIZE				{SIZE_WIDTH = 300, SIZE_HEIGHT, SIZE_SCALING};

#define ORIENT_H			  8
#define ORIENT_V			 94
#define ORIENT_TEXT			"Orientation"
enum	ORIENT				{ORIENT_PORTRAIT = 200, ORIENT_LANDSCAPE};

#define SAMPLE_H			(SETUP_WIDTH - PORT_HEIGHT - 20)
#define SAMPLE_V			  8
#define SAMPLE_WIDTH		(PORT_HEIGHT + 16)
#define SAMPLE_HEIGHT		(PORT_HEIGHT + 16)

#define BUTTON_WIDTH		 70
#define BUTTON_HEIGHT		 20

#define LINE_V				(SETUP_HEIGHT - BUTTON_HEIGHT - 23)

#define PRINT_BUTTON_H		  6
#define PRINT_BUTTON_V		(SETUP_HEIGHT - BUTTON_HEIGHT - 11)
#define PRINT_BUTTON_TEXT	"Printer..."
#define SET_OK_BUTTON_H		(SETUP_WIDTH - BUTTON_WIDTH - 10)
#define SET_OK_BUTTON_V		PRINT_BUTTON_V
#define SET_OK_BUTTON_TEXT	"OK"
#define SET_CANCEL_BUTTON_H	(SET_OK_BUTTON_H - BUTTON_WIDTH - 12)
#define SET_CANCEL_BUTTON_V	SET_OK_BUTTON_V
#define SET_CANCEL_BUTTON_TEXT	"Cancel"

enum	BUTTONS				{M_OK = 1, M_CANCEL, M_PRINT};

#define VIEW_COLOR			216

class	TSetupView;
class	TSampleView;

filter_result	SetupKeyFilter(BMessage*, BHandler**, BMessageFilter*);	


//====================================================================

class BSetup : public BWindow {

public:
TSetupView		*fView;

private:
char			fResult;
long			fSetupSem;
BMessage		*fSetupMessage;
BMessageFilter	*fFilter;

public:
				BSetup(BMessage*, char*);
				~BSetup(void);
virtual	void	MessageReceived(BMessage*);
		long	Go(void);
};

//--------------------------------------------------------------------

class TSetupView : public BView {

public:

BTextControl	*fHeight;
BTextControl	*fScaling;
BTextControl	*fWidth;

private:

long			fOrient;
float			fPageHeight;
float			fPageWidth;
float			fScale;
BMenuField		*fOrientation;
BMenuField		*fPaper;
TSampleView		*fView;

public:
				TSetupView(BRect, BMessage*);
virtual void	AttachedToWindow(void);
virtual	void	Draw(BRect rect);
virtual	void	MessageReceived(BMessage*);
		void	UpdateMessage(BMessage*);

private:
		void	FindMenu(void);
		void	NiceString(char*, float);
};

//--------------------------------------------------------------------

class TSampleView : public BView {

private:

long			fOrient;
float			fWidth;
float			fHeight;
BBitmap			*fLandscape;
BBitmap			*fPortrait;

public:
				TSampleView(BRect, long, float, float);
				~TSampleView(void);
virtual	void	Draw(BRect rect);
		void	SetOrientation(long);
		void	SetPageSize(float, float);
};
#endif
