/*
	Copyright 1999, Be Incorporated.   All Rights Reserved.
	This file may be used under the terms of the Be Sample Code License.
*/
#ifndef _MOVIEVIEW_H_
#define _MOVIEVIEW_H_

/* MovieView just displays each frame of the movie. */
/* Frames are passed in through NewFrame(); the     */
/* bitmap is not copied.  PositionFrame() determines*/
/* the top left corner of the movie.                */

#include <View.h>
#include <Point.h>

class FlipView;

class MovieView : public BView
{
 public:
							MovieView(BRect, FlipView*);
							~MovieView();
							
	void					Draw(BRect R);
	void					NewFrame(BBitmap*);
	void					ResizeTo(float h, float v);
	
	void					PositionFrame(BRect);
	
 private:
	

	FlipView				*fParent;
	BBitmap					*fFrame;
	BPoint					fMovieCorner;
};



#endif
