/*
	Copyright 1999, Be Incorporated.   All Rights Reserved.
	This file may be used under the terms of the Be Sample Code License.
*/
#include "MovieView.h"
#include "FlipView.h"

MovieView::MovieView(BRect R, FlipView *parent)
	: BView(R, "movieview", B_WILL_DRAW, 0)
{
	fParent = parent;
	fFrame = NULL;
	SetViewColor(216,216,216);
}

MovieView::~MovieView()
{
	// empty
}

void
MovieView::Draw(BRect R)
{
	if(fFrame){
		DrawBitmap(fFrame, fMovieCorner);
	} else {
		const char *drop = "Drop a movie on me!";
		const float FONTSIZE = 20.;

		SetFont(be_bold_font);
		SetFontSize(FONTSIZE);
		float width = StringWidth(drop);
		float posx = (Bounds().Width() - width) / 2;
		float posy = (Bounds().Height() - FONTSIZE) / 2;
		DrawString(drop, strlen(drop), BPoint(posx, posy));
	}

	BView::Draw(R);
}

void
MovieView::NewFrame(BBitmap *bitmap)
{
	fFrame = bitmap;
	if(fFrame == NULL){
		Invalidate();
		return;
	}	
	Window()->Lock();
	DrawBitmap(fFrame, fMovieCorner);
	Window()->Unlock();
}

void
MovieView::PositionFrame(BRect R)
{
	float cx = (Bounds().Width() - R.Width()) / 2;
	float cy = (Bounds().Height() - R.Height()) / 2;
	fMovieCorner.Set(cx,cy);		
}

void
MovieView::ResizeTo(float h, float v)
{
	BView::ResizeTo(h,v);
	if(fFrame){
		PositionFrame(fFrame->Bounds());
	}
}
