/*
	Copyright 1999, Be Incorporated.   All Rights Reserved.
	This file may be used under the terms of the Be Sample Code License.
*/
#ifndef _LAYOUT_H_
#define _LAYOUT_H_

/* Layout handles the positioning of the flip pages */
/* on the printed page.  Doesn't do anything fancy, */
/* just tiles them down, then across.  Begin() creates */
/* the BPrintJob, AddFrame() actually creates a     */
/* FlipPage and prints it to the page, and FinishLastPage() */
/* commits the job and destroys the BPrintJob. */
/* fDummy is an offscreen window needed in order to print. */

#include <View.h>
#include <Rect.h>
#include <List.h>
#include <Message.h>
#include <PrintJob.h>

class Layout
{
 public:
						Layout();
						~Layout();

	void				SetFrameSize(BRect);
	void				AddFrame(BBitmap*);

	int32				FlipPagesPerPage();

	status_t			Begin();
	void				FinishLastPage();

	status_t			PageSetup();
	void				PrinterChanged();

 private:

	BWindow				*fDummyWin;

	int32				fNumFlipsOnCurPage;

	void				Reposition();
	status_t			JobSetup();

	BMessage 			*fPrintSettings;

	int32				fHorizontalPages;
	int32				fVerticalPages;

	BPrintJob			*fPrintJob;
	BRect 				fFlipPageRect;

	BPoint				fOffset;
};


#endif