/*
	Copyright 1999, Be Incorporated.   All Rights Reserved.
	This file may be used under the terms of the Be Sample Code License.
*/
#include "FlipWin.h"

#include <Application.h>
#include <MenuBar.h>
#include <Menu.h>
#include <MenuItem.h>

FlipWin::FlipWin()
	: BWindow(WIN_RECT, "Flipbook!", B_TITLED_WINDOW, B_NOT_RESIZABLE)
{
	generate_sem = create_sem(1, "generate_sem");

	// create file menu
	BMenuBar *mb = new BMenuBar(BRect(0,0,WIN_RECT.right,15), "menubar");
	BMenu *menu = new BMenu("File");
	menu->AddItem(new BMenuItem("Open", new BMessage(OPEN_MOVIE), 'O'));
	menu->AddSeparatorItem();
	menu->AddItem(new BMenuItem("Page Setup", new BMessage(PAGE_SETUP), 'P',
								B_SHIFT_KEY));
	menu->AddSeparatorItem();
	BMenuItem *item = new BMenuItem("Quit", new BMessage(B_QUIT_REQUESTED), 'Q');
	item->SetTarget(be_app);
	menu->AddItem(item);
	mb->AddItem(menu);

	// create settings menu
	menu = new BMenu("Settings");
	BMenu *placementMenu;
	menu->AddItem(new BMenuItem(placementMenu = new BMenu("Placement"), NULL));
	placementMenu->SetRadioMode(true);
	placementMenu->AddItem(new BMenuItem("Left-Handed", new BMessage(LEFT_HANDED)));
	placementMenu->AddItem(item = new BMenuItem("Right-Handed", new BMessage(RIGHT_HANDED)));
	item->SetMarked(true);
	mb->AddItem(menu);
	
	AddChild(mb);

	// create the flipview
	float top = mb->Bounds().bottom;
	fFlipView = new FlipView(BRect(0,top,mb->Bounds().Width(),Bounds().bottom));
	AddChild(fFlipView);									

	fFilter = new BMessageFilter(B_ANY_DELIVERY, B_ANY_SOURCE, B_KEY_DOWN,
									MarkCountFilter);
	AddCommonFilter(fFilter);
}

FlipWin::~FlipWin()
{
	delete_sem(generate_sem);
	Lock();
	RemoveCommonFilter(fFilter);
	Unlock();
	delete fFilter;
}


void
FlipWin::MessageReceived(BMessage* msg)
{
	if(msg->WasDropped() && msg->HasRef("refs")){
		/* handle it as if it came from the OpenPanel */
		msg->what = B_REFS_RECEIVED;
	}

	switch(msg->what)
	{
	 case OPEN_MOVIE:
	 case PAGE_SETUP:
	 case GENERATE:
	 case LEFT_HANDED:
	 case RIGHT_HANDED:
	 case B_PRINTER_CHANGED:
	 case B_REFS_RECEIVED:
		PostMessage(msg, fFlipView);
		break;
	 default:
		BWindow::MessageReceived(msg);
		break;
	}
}

bool 
FlipWin::QuitRequested()
{
	// crude locking system...can't quit while generating a flipbook
	if(acquire_sem_etc(generate_sem,1,B_TIMEOUT,0) != B_OK){
		return false;
	}

	be_app->PostMessage(B_QUIT_REQUESTED);
	return true;
}

filter_result
MarkCountFilter(BMessage *msg, BHandler **target, BMessageFilter *filter)
{
	/* we're not checking who the target is, but for now this is okay, */
	/* since we only have one text control. */
	
	ulong mods = 0;
	mods = msg->FindInt32("modifiers");
	if (mods & B_COMMAND_KEY)
		return B_DISPATCH_MESSAGE;

	
	long key;
	const uchar *bytes = NULL;
	if (msg->FindString("bytes", (const char **)&bytes) != B_NO_ERROR)
		return B_DISPATCH_MESSAGE;

	key = bytes[0];
	if (key < '0') {
		if ((key != B_TAB) && (key != B_BACKSPACE) && (key != B_ENTER) &&
			(key != B_LEFT_ARROW) && (key != B_RIGHT_ARROW) &&
			(key != B_UP_ARROW) && (key != B_DOWN_ARROW) && (key != '.')) 
			return B_SKIP_MESSAGE;
	} else if (key > '9') {
		return B_SKIP_MESSAGE;
	}	

	return B_DISPATCH_MESSAGE;

}
