/*
	Copyright 1999, Be Incorporated.   All Rights Reserved.
	This file may be used under the terms of the Be Sample Code License.
*/
#ifndef _FLIPVIEW_H_
#define _FLIPVIEW_H_

/* FlipView is where most of the action happens.  It has */
/* two children: a MovieView and a ControlView.  FlipView */
/* loads the movie, and actually generates the flipbook. */

#include <View.h>
#include <FilePanel.h>
#include <Messenger.h>
#include <Entry.h>
#include <MediaTrack.h>
#include <MediaFile.h>
#include <Bitmap.h>

#include "Layout.h"
#include "MovieView.h"
#include "ControlView.h"

class FlipView : public BView
{
	friend					MovieView;
	friend					ControlView;

 public:
							FlipView(BRect);
							~FlipView();
	
	void					MessageReceived(BMessage*);
	
	bool					HasMovie() const;
	
 private:
	
	void					ShowOpenPanel();
	status_t				PrepareMovie();
	
	static int32			GenerateHook(void*);	
	int32					GenerateFlipbook();

	void					DoResize();
	
	MovieView				*fMovieView;
	ControlView				*fControlView;
		
	entry_ref				fMovieRef;
	BMediaFile				*fVideoFile;
	BMediaTrack				*fVideoTrack;
	BBitmap					*fCurFrame;

	Layout					*fLayout;

	BFilePanel				*fOpenPanel;
	BMessenger				*fOpenPanelTarget;
};


#endif
