/*
	Copyright 1999, Be Incorporated.   All Rights Reserved.
	This file may be used under the terms of the Be Sample Code License.
*/
#ifndef _FLIPPAGE_H_
#define _FLIPPAGE_H_

/* FlipPage is a page in the flipbook.  Very */
/* transient -- it is created, passed to     */
/* BPrintJob::DrawView(), the destroyed.     */

#include <View.h>
#include <Bitmap.h>

class FlipPage : public BView
{
 public:
						FlipPage(BRect, BBitmap*);
						~FlipPage();
						
	void				Draw(BRect);

	static void			ResetPageNums();
	static void			IsRightHanded(bool);
						
 private:

	BBitmap				*fImage;

	int64				fMyPageNum;
	static int64		fNextPageNum;

	static bool			fIsRightHanded;
};

#endif
