/*
	Copyright 1999, Be Incorporated.   All Rights Reserved.
	This file may be used under the terms of the Be Sample Code License.
*/
#include "FlipPage.h"
#include <stdio.h>

int64 FlipPage::fNextPageNum = 0;
bool  FlipPage::fIsRightHanded = true;

FlipPage::FlipPage(BRect frame, BBitmap *image)
	: BView(frame, "flippage", B_WILL_DRAW, 0)
{
	fImage = image;
	fMyPageNum = fNextPageNum++;
}

FlipPage::~FlipPage()
{
	// empty
}

void
FlipPage::Draw(BRect)
{
	const int32 FONTSIZE= 8;
	float rotation;
	BPoint penPt;
	BPoint bitmapPt;
	
	if(fIsRightHanded){
		penPt.Set(FONTSIZE+3,Bounds().Height()-5);
		bitmapPt.Set(50,5);
		rotation = 90;
	} else {
		penPt.Set(Bounds().Width() - FONTSIZE -3, 5);		
		bitmapPt.Set(5,5);
		rotation = -90;
	}

	BFont font;
	GetFont(&font);
	font.SetSize(FONTSIZE);
	font.SetRotation(rotation);
	SetFont(&font, B_FONT_SIZE|B_FONT_ROTATION);
		
	StrokeRect(Bounds());
	char str[32];
	sprintf(str, "%ld", fMyPageNum);

	MovePenTo(penPt);
	DrawString(str);

	DrawBitmap(fImage, bitmapPt);	
}

void
FlipPage::ResetPageNums()
{
	fNextPageNum = 0;
}

void
FlipPage::IsRightHanded(bool val)
{
	fIsRightHanded = val;
}

