/*
	Copyright 1999, Be Incorporated.   All Rights Reserved.
	This file may be used under the terms of the Be Sample Code License.
*/
#ifndef _CONTROLVIEW_H_
#define _CONTROLVIEW_H_

#include <View.h>
#include <Box.h>
#include <TextControl.h>
#include <Button.h>
#include "FlipMsg.h"

const BRect STAT_BOX(10,20,290,110);
const BRect MARK_BOX(150,130,290-1,150);

const int32 GEN_BTN_LEN = 75;
const int32 GEN_BTN_HEIGHT = 25;

class StatusBox;
class FlipView;

class ControlView : public BView
{
 public:
							ControlView(BRect, FlipView*);
							~ControlView();
	
	void					AttachedToWindow();
	void					MessageReceived(BMessage*);
	
	void					EnableGenerateButton(bool);
	void					UpdatePrintStats();

	int32					MarkCount() const;
	
 private:

	void					SetMarkCount(const char*);

	FlipView				*fParent;	

	StatusBox				*fStatusBox;
	BButton					*fGenerate;
	BTextControl			*fMarkControl;	
	int32					fMarkCount;	

};


class StatusBox : public BBox
{
 public:
							StatusBox(BRect);
							~StatusBox();
	
	void					Draw(BRect);
	
	void					FramesMarked(int64);
	void					FramesPerPage(int64);
	void					TotalPages(int64);
	
 private:

	int64					fMarked;
	int64					fFramesPerPage;
	int64					fPages;

};

#endif
