#include "BorderPrint.h"
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <Bitmap.h>
#include <time.h>

const float BANNER_HEIGHT = 20.0;
const float BANNER_FONT_SIZE = 12.0;
const float INNER_VERT_MARGIN = 5.0;
const float INNER_HOR_MARGIN = 7.0;
const float BANNER_TEXT_BASELINE = 14.0;
const float BANNER_TEXT_SIDESPACE = 10.0;

BorderPrint::BorderPrint(const char *jobname)
	: BPrintJob(jobname)
{
	fIsNewPage = true;
	fTitle = strdup(jobname);
	fNumSpooledPages = 0;
	winBitmap = NULL;

	CreateBorderView();
}

BorderPrint::~BorderPrint()
{
	free(fTitle);
	delete winBitmap;
}

void  BorderPrint::SpoolPage()
{
	fIsNewPage = true;
	fNumSpooledPages++;
	BPrintJob::SpoolPage();
}

BRect
BorderPrint::PrintableRect()
{
	CreateBorderView();
	BRect printableRect = fBorderView->ApplicationUsableArea();
	return printableRect;
};

void
BorderPrint::CreateBorderView()
{
	BRect printableRect = BPrintJob::PrintableRect();
	fBorderView = new BorderView(printableRect, fTitle);

	delete winBitmap;
	winBitmap = new BBitmap(BRect(0,0,2,2), B_CMAP8, true);
	winBitmap->AddChild(fBorderView);
}

void
BorderPrint::DrawView(BView *view, BRect clip, BPoint where)
{
	if(fIsNewPage) {
		fBorderView->PageNum(FirstPage()+fNumSpooledPages);
		BPrintJob::DrawView(fBorderView, BPrintJob::PrintableRect(), BPoint(0,0));
		fIsNewPage = false;
	}		

	BPoint offset = fBorderView->Offset();
	BPrintJob::DrawView(view, clip, where+offset);	
}

BorderPrint::BorderView::BorderView(BRect R, const char *title)
	: BView(R, "BorderView", B_FOLLOW_ALL, B_WILL_DRAW)
{
	fPrintableRect = R;
	fTitle = strdup(title);
	fPageNumber = 0;

	time_t a_time;
	time(&a_time);
	fTime = strdup(asctime(localtime(&a_time)));
	fTime[strlen(fTime)-1] = '\0';	// replace \n with \0

}

BorderPrint::BorderView::~BorderView()
{
	free(fTitle);
	free(fTime);	
}

void
BorderPrint::BorderView::PageNum(int32 page)
{
	fPageNumber = page;
}

void
BorderPrint::BorderView::Draw(BRect)
{
	SetHighColor(200,200,200);
	
	BPoint pt0(0,0);
	BPoint pt1(fPrintableRect.right,BANNER_HEIGHT);
	BPoint pt2(0,fPrintableRect.bottom-BANNER_HEIGHT);
	BPoint pt3(fPrintableRect.right,fPrintableRect.bottom);
	BPoint pt4(0,BANNER_HEIGHT);
	BPoint pt5(fPrintableRect.right,fPrintableRect.bottom-BANNER_HEIGHT);
	
	FillRect(BRect(pt0, pt1));
	FillRect(BRect(pt2, pt3));

	SetPenSize(3.0);
	SetHighColor(0,0,0);
	StrokeRect(BRect(pt0, pt1));
	StrokeRect(BRect(pt2, pt3));
	StrokeLine(pt4, pt2);
	StrokeLine(pt1, pt5);

	SetFontSize(BANNER_FONT_SIZE);

	// truncate the title if it's too long
	while(StringWidth(fTitle) > fPrintableRect.Width() - 2*BANNER_TEXT_SIDESPACE) {
		fTitle[strlen(fTitle)-1] = '\0';
	}

	float strX = (fPrintableRect.Width() - StringWidth(fTitle)) / 2;
	DrawString(fTitle, BPoint(strX, BANNER_TEXT_BASELINE));

	char str[256];
	DrawString(fTime, BPoint(10, pt3.y-(BANNER_HEIGHT-BANNER_TEXT_BASELINE)));

	sprintf(str, "Page: %d\0", fPageNumber);
	strX = (fPrintableRect.Width() - StringWidth(str) - BANNER_TEXT_SIDESPACE);
	DrawString(str, BPoint(strX, pt3.y-(BANNER_HEIGHT-BANNER_TEXT_BASELINE)));

}

BRect
BorderPrint::BorderView::ApplicationUsableArea()
{
	BRect tmp = fPrintableRect;
	tmp.top += BANNER_HEIGHT + INNER_VERT_MARGIN;
	tmp.bottom -= BANNER_HEIGHT + INNER_VERT_MARGIN;
	tmp.left += INNER_HOR_MARGIN;
	tmp.right -= INNER_HOR_MARGIN;
	return tmp;
}

BPoint
BorderPrint::BorderView::Offset()
{
	BPoint tmp(INNER_HOR_MARGIN, BANNER_HEIGHT + INNER_VERT_MARGIN);
	return tmp;
}

