
#include "Tool.h"
#include "BitmapDocument.h"
#include "BitmapEditor.h"
#include "PaintApp.h"

/***********************************************/

BTool::BTool()
{
};

void BTool::MessageReceived(BMessage *msg)
{
	const rgb_color *cp;
	int32 i;
	
	/*

		"region"	: the area in which the tool is allowed to
					  have an effect (i.e. the bounds of the window)
		"bitmap"	: the bitmap on which the tool is acting
		"scale"		: the scale of the bitmap as it is displayed
					  (scale * bitmap unit = screen unit)
		"ulhc"		: "upper left hand corner" of the bitmap in the
					  client view's coordinate system
		"client"	: the BView requesting use of the tool
		"point"		: the location at which the tool was invoked
		"fore"		: current foreground color
		"back"		: current background color
		"button"	: the mouse button the tool was invoked with

	*/

	m_validRect = msg->FindRect("region");
	msg->FindPointer("bitmap",(void**)&m_document);
	msg->FindFloat("scale",&m_curScale);
	msg->FindPoint("ulhc",&m_curULHC);
	msg->FindPointer("client",(void**)&m_client);
	msg->FindPoint("point",&m_invokePoint);
	msg->FindData("fore",B_RGB_COLOR_TYPE,0,(const void**)&cp,&i); m_foreColor=*cp;
	msg->FindData("back",B_RGB_COLOR_TYPE,0,(const void**)&cp,&i); m_backColor=*cp;
	msg->FindInt32("button",(int32*)&m_invokedWith);

	m_document->Lock();
		m_document->View()->SetHighColor(m_foreColor);
		m_document->View()->SetLowColor(m_backColor);
	m_document->Unlock();

	BWindow *win = m_client->Window();
	m_invokePoint = PointOnBitmap(m_invokePoint);
	m_oldPoint = m_invokePoint;

	StartUsing();

	BPoint curOnBitmap = m_invokePoint;
	uint32 curButtons = m_invokedWith;
	while (curButtons & m_invokedWith) {
		if ((curOnBitmap.x != m_oldPoint.x) ||
			(curOnBitmap.y != m_oldPoint.y) ) {
			PointerMoved(curOnBitmap);
			m_oldPoint = curOnBitmap;
		};

		snooze(20000);
		win->Lock();
			m_client->GetMouse(&curOnBitmap,&curButtons,TRUE);
			curOnBitmap = PointOnBitmap(curOnBitmap);
		win->Unlock();
	};

	StopUsing();
};

BPoint BTool::PointOnBitmap(BPoint pointOnClient)
{
	BPoint p;
	p.x = floor((pointOnClient.x+m_curULHC.x)/m_curScale);
	p.y = floor((pointOnClient.y+m_curULHC.y)/m_curScale);
	return p;
};

