
#include "BitmapDocument.h"
#include <File.h>
#include <Region.h>

#define MAX_READER_COUNT 10000

void BBitmapDocument::Load(BFile *f)
{
	if (m_bitmap) delete m_bitmap;

	BRect r;
	color_space cs;
	int32 bitslen;
	f->Read((void*)&r,(size_t)sizeof(r));
	f->Read(&cs,sizeof(cs));
	f->Read(&bitslen,sizeof(bitslen));
	m_bitmap = new BBitmap(r,cs,TRUE);
	f->Read(m_bitmap->Bits(),bitslen);

	m_view = new BView(r,"BitmapDrawer",B_FOLLOW_ALL,0);
	m_bitmap->AddChild(m_view);
};

void BBitmapDocument::Store(BFile *f)
{
	if (!m_bitmap) return;

	BRect r = m_bitmap->Bounds();
	color_space cs = m_bitmap->ColorSpace();
	int32 bitslen = m_bitmap->BitsLength();
	f->Write(&r,sizeof(r));
	f->Write(&cs,sizeof(cs));
	f->Write(&bitslen,sizeof(bitslen));
	f->Write(m_bitmap->Bits(),bitslen);
};

void BBitmapDocument::ResizeTo(float width, float height)
{
};

BBitmapDocument::BBitmapDocument(BFile *f)
{
	m_bitmap = NULL;
	m_view = NULL;
	m_readerLock = create_sem(MAX_READER_COUNT,"readerLock");
	Load(f);
};

BBitmapDocument::BBitmapDocument(float width, float height)
{
	m_bitmap = new BBitmap(BRect(0,0,width-1,height-1),B_RGB_32_BIT,TRUE);
	BRect r(0,0,width-1,height-1);
	m_view = new BView(r,"BitmapDrawer",B_FOLLOW_ALL,0);
	m_readerLock = create_sem(MAX_READER_COUNT,"readerLock");
	m_bitmap->AddChild(m_view);
};

BBitmapDocument::~BBitmapDocument()
{
	if (m_bitmap) delete m_bitmap;
	delete_sem(m_readerLock);
};
				
void BBitmapDocument::AddEditor(BView *v)
{
	m_editors.AddItem(v);
};

void BBitmapDocument::RemoveEditor(BView *v)
{
	m_editors.RemoveItem(v);
};

void BBitmapDocument::SetDirty(BRegion *r)
{
	BMessage msg(bmsgBitmapDirty);
	for (int i=0;i<r->CountRects();i++)
		msg.AddRect("rect",r->RectAt(i));

	for (int i=0; i<m_editors.CountItems(); i++) {
		BView *v = (BView*)m_editors.ItemAt(i);
		BLooper *loop = v->Looper();
		if (loop) loop->PostMessage(&msg,v);
	};
};

void BBitmapDocument::Lock()
{
	acquire_sem_etc(m_readerLock,MAX_READER_COUNT,0,0);
	m_bitmap->Lock();
};

void BBitmapDocument::Unlock()
{
	m_bitmap->Unlock();
	release_sem_etc(m_readerLock,MAX_READER_COUNT,0);
};

void BBitmapDocument::ReadLock()
{
	acquire_sem(m_readerLock);
};

void BBitmapDocument::ReadUnlock()
{
	release_sem(m_readerLock);
};
