// TrackReader.h
// -------------
// A BSoundFile-ish wrapper around BMediaTrack. Allows you
// to read data from sound files. Like BSoundFile, you can
// read an arbitrary number of frames and seek precisely to
// a specific frame.
//
// Copyright 1999, Be Incorporated.   All Rights Reserved.
// This file may be used under the terms of the Be Sample Code License.

#if !defined(TrackReader_h)
#define TrackReader_h

#include <MediaTrack.h>


class ATrackReader
{
public:
		ATrackReader(BMediaTrack * track, const media_format & fmt, BMediaFile * mFile);
		ATrackReader(BFile * file, const media_format & fmt);
		~ATrackReader();

		ssize_t ReadFrames(void * dest, int32 frameCount);
		ssize_t FrameSize();
		ssize_t SampleSize();
		BMediaTrack * Track();
		ssize_t CountFrames();
		const media_format & Format() const;
		status_t SeekToFrame(int64 *ioFrame);
		BFile * File();

private:
		char * m_buffer;
		ssize_t m_inBuffer;
		ssize_t m_bufUnused;
		ssize_t m_frameSize;
		BMediaTrack * m_track;
		media_format m_fmt;
		size_t m_bufSize;
		BFile * m_file;
		BMediaFile * m_mediaFile;

		ssize_t read_glob(void * dest, int32 frameCount);
};


ATrackReader * open_sound_file(const entry_ref * file, status_t * outError = NULL);


#endif	//	TrackReader_h
