//	Wnd.cpp
//
// 	Window with a menu and a text view to allow the user to make calls
//  into ethernet drivers, and display ststus info. 
//
// 	russ 4/21/99
//
//	Copyright 1997-1999, Be Incorporated.   All Rights Reserved.
//	This file may be used under the terms of the Be Sample Code License.


#include "Wnd.h"
#include "Resource.h"
#include "IO.h"
#include <Application.h>
#include <MenuBar.h>
#include <MenuItem.h>

#include <stdio.h>
#include <Alert.h>

// Helpers to tidy up methods 
float CreateMenuHelper(BWindow *Wnd);

Wnd::Wnd() :BWindow(BRect(100, 200, 100+500, 200+300), "E-Drive",
					B_TITLED_WINDOW, B_WILL_DRAW)
{	
	m_in_out = NULL;
	
	AddParts();
	
	m_textView->SetText("Choose open from file menu.", 30);
}

bool Wnd::QuitRequested()
{
    if (m_in_out){
		m_in_out->Close();
		m_in_out->SetPersistantSettings();
	}
		 
	be_app->PostMessage(B_QUIT_REQUESTED);
	return BWindow::QuitRequested();
}

void Wnd::MessageReceived(BMessage* message)
{
	char buf[512];
	BAlert* alert;
	
	switch(message->what)
	{
		case MSG_OPEN:
			m_in_out = new IO(this);
			
			sprintf(buf, "E-Drive (Open and Receive)");	
			SetTitle(buf);			    
		break;
		
		
		case MSG_TRANSMIT:
			if (!m_in_out){
				alert = new BAlert("", "No opened driver. Please select Open from the File menu.", "OK");
	    		alert->Go();
				return;
			}
		
			sprintf(buf, "Transmit: %s", m_in_out->m_DriverName);	
			SetTitle(buf);		
			m_in_out->IOCtrl(MSG_TRANSMIT_PACKETS);    
		break;
		
		case MSG_SETTINGS:
			// Because the settings panel is displayed from IO.cpp and
			// the contructor leads to and open on the driver, the settings
			// panel is blocked until a driver has be loaded. This is not great,
			// the panel should be available at any time, but heck this can
			// be done later.
			if (!m_in_out){
				alert = new BAlert("", "No opened driver. Please select Open from the File menu.", "OK");
	    		alert->Go();
				return;
			}
					
			sprintf(buf, "Settings: %s", m_in_out->m_DriverName);	
			SetTitle(buf);
			
			m_in_out->ShowIOSettings();
		break;
		
		case MSG_CLOSE_APP:
			QuitRequested();	    
		break;
		
		default:
			BWindow::MessageReceived(message);
	}
}

void Wnd::AddParts()
{
	float menuHeight;
	
	menuHeight = CreateMenuHelper(this);
	
	BRect rect(Bounds());
	rect.top = menuHeight + 1;
	BRect txtRect(rect);
	txtRect.OffsetTo(0, 0);
	txtRect.InsetBy(3, 3);
	m_textView = new BTextView(rect, "", txtRect, B_FOLLOW_ALL, B_WILL_DRAW);
	AddChild(m_textView);	
}

void Wnd::Print(char* buf)
{
  	char newLineBuf[512];
    
	if (Lock()){
		sprintf(newLineBuf, "\n%s", buf);
		
		m_textView->Insert(m_textView->TextLength(), newLineBuf, strlen(newLineBuf));
		m_textView->ScrollToOffset(m_textView->TextLength());
		
		Unlock();		
	}
}

float CreateMenuHelper(BWindow *Wnd)
{
	BRect menuRect;
  
    //	Menu View
	menuRect = Wnd->Bounds(); 
	menuRect.left = 0;
	menuRect.right = 0;
	BMenuBar* MenuBar = new BMenuBar(menuRect, "Menu");
	BMenuItem* item;
	
    //	File menu
	BMenu* FileMenu = new BMenu("File");
	item = new BMenuItem("Open and Receive", new BMessage(MSG_OPEN),'O');
	FileMenu->AddItem(item);
	item = new BMenuItem("Transmit", new BMessage(MSG_TRANSMIT),'T');
	FileMenu->AddItem(item);
	FileMenu->AddSeparatorItem();
	item = new BMenuItem("Settings", new BMessage(MSG_SETTINGS),'S');
	FileMenu->AddItem(item);					
	FileMenu->AddSeparatorItem();
	item = new BMenuItem("Quit Application", new BMessage(MSG_CLOSE_APP),'Q');
	FileMenu->AddItem(item);
	
    // Create the menu bar
	FileMenu->SetTargetForItems(Wnd);
	
	MenuBar->AddItem(FileMenu);
	
	Wnd->AddChild(MenuBar);
	
	return MenuBar->Bounds().bottom;	
}

