//  SettingsPanel.h
//
// 	This panel will get user settings. 
// 
//	russ 5/21/98
// 
//	Copyright 1997-1999, Be Incorporated.   All Rights Reserved.
//	This file may be used under the terms of the Be Sample Code License.

#ifndef _SETTINGSPANEL_H
#define _SETTINGSPANEL_H

#include "Resource.h"

class BCallbackHandler;

class SettingsPanel : public BWindow
{
	public:
		SettingsPanel(BCallbackHandler* cb);
		~SettingsPanel();
		
		virtual void MessageReceived(BMessage *msg); 
		
		void SetSrcIPAddress(const char* srcIPAddress);
		void SetDstIPAddress(const char* dstIPAddress);
		void SetDstMacAddress(const char* dstMacAddress);		
		void SetShowPackets(const bool showPackets);
		void SetPingReply(const bool pingReply);
		void SetShowBroadcasts(const bool showBroadcasts);		
		
		void GetSrcIPAddress(char* srcIPAddress);
		void GetDstIPAddress(char* dstIPAddress);
		void GetDstMacAddress(char* dstMacAddress);		
		void GetShowPackets(bool* showPackets);
		void GetPingReply(bool* pingReply);
		void GetShowBroadcasts(bool* showBroadcasts);
		
		char m_srcIPAddress[256];
		char m_dstIPAddress[256];
		char m_dstMacAddress[256];
		bool m_showPackets;
		bool m_pingReply;
		bool m_showBroadcasts;
		
	private:
		BCallbackHandler* m_CallBack;
		BBox*			m_MainBG;
		BStringView* 	m_Label;
		BTextControl*	m_srcIPAddressCtl;
		BTextControl*	m_dstIPAddressCtl;
		BTextControl*	m_dstMacAddressCtl;
		BCheckBox*		m_showPacketsCtl;
		BCheckBox*		m_pingReplyCtl;
		BCheckBox*		m_showBroadcastsCtl;
		
		BButton*		m_CancelBtn;
		BButton*		m_DoneBtn;
		
		void CreatePanelUI(); 
		void Update(int16 direction);
		
								
};		

#endif // _SETTINGSPANEL_H