// 	IO.h
//
//	This class is a wrapper around some basic ethernet driver calls.
//	It handles all packet receives and transmits. There is also a simple
//	ping reply method built in to make driver development easier. User 
//  settings settings are also handled by this class.  
//
//  russ 4/28/99
// 
//	Copyright 1997-1999, Be Incorporated.   All Rights Reserved.
//	This file may be used under the terms of the Be Sample Code License.

#ifndef	_IO_H
#define	_IO_H

#include <Window.h>

class BCallbackHandler {
public:
	virtual void Done(status_t status) = 0;
};

class DriverNamePanel;
class Wnd;
class SettingsPanel;


class IO : public BCallbackHandler
{
	public:	
				IO(Wnd* parent);
						
		void 	Open();
		bool    IOCtrl(uint32 msg);
		void	Close();
		void 	DumpPacket(const char* msg, uchar* buf);
		void	ShowIOSettings();
		void 	SetPersistantSettings();
		bool    PrepareArpReply(uchar* pRxPacket, uchar* pTxPacket,
													uint16* packetLength);	
		bool    PreparePingReply(uchar* pRxPacket, uchar* pTxPacket,
													uint16* packetLength);																						
		bool	PreparePingRequest(uchar* pTxPacket, uint16* packetLength);
		void    ProcessPingReply(uchar* pRxPacket, uint16* packetLength);
				
		// Callback from user input panels.
		void 	Done(status_t status);
						
		int		m_id; // Driver id.		
		Wnd* 	m_parent;			
		char 	m_DriverName[256];
		bool 	m_showPackets;
		bool 	m_pingReply;
		bool 	m_showBroadcasts;
		
		bigtime_t 	m_timevalout; // Profile values.
		bigtime_t 	m_timevalin;
		bigtime_t 	m_timeInterval;	
			
	private:		
		void 	GetPersistantSettings();
		
		DriverNamePanel* 	m_DriverNamePanel;
		SettingsPanel* 	m_SettingsPanel;
		bool 	m_SettingsPanelUp;
		bool 	m_NamePanelUp;
							
		thread_id 	m_rxThread;
		thread_id 	m_txThread;		
		
		char 	m_srcIPAddress[256];
		uint8 	m_srcMacAddress[6]; // From card so left uint8.	
		char 	m_dstIPAddress[256];
		char 	m_dstMacAddress[256];			
		
		int16 	m_seqnum; // ICMP sequence number.
		int16 	m_payloadLength; // ICMP data length.						
};

#endif // _IO_H

