//	DriverNamePanel.h
//
// 	This panel will get a driver name from the user. The
// 	driver name is what links this user space app, with
//	the kernel.
// 
//	russ 5/21/98
//
//	Copyright 1997-1999, Be Incorporated.   All Rights Reserved.
//	This file may be used under the terms of the Be Sample Code License.

#ifndef _DRIVERNAMEPANEL_H
#define _DRIVERNAMEPANEL_H

#include "Resource.h"

class BCallbackHandler;

class DriverNamePanel : public BWindow
{
	public:
		DriverNamePanel(BCallbackHandler* cb);
		~DriverNamePanel();
		
		virtual void MessageReceived(BMessage *msg); 
		
		void SetDriverName(const char* driverName);
		void GetDriverName(char* driverName);
		
	private:
		BCallbackHandler* m_CallBack;
		char			m_DriverName[512];
		BBox*			m_MainBG;
		BTextControl*	m_DriverNameCtl;
		BButton*		m_CancelBtn;
		BButton*		m_DoneBtn;
		
		void CreatePanelUI(); 
		void Update(int16 direction);						
};		

#endif // _DRIVERNAMEPANEL_H