//  DriverNamePanel.cpp
//
// 	This panel will get a driver name from the user. The
// 	driver name is what links this user space app, with
//	the kernel.
// 
//	russ 5/21/98
// 
//	Copyright 1997-1999, Be Incorporated.   All Rights Reserved.
//	This file may be used under the terms of the Be Sample Code License.

#include <string.h>
#include <stdlib.h>
#include <Alert.h>
#include <Box.h>
#include <Button.h>
#include <Screen.h>
#include <TextControl.h>
#include <Window.h>

#include "Resource.h"
#include "DriverNamePanel.h"
#include "IO.h"

const char* kDrvNameStr = "Driver name:";
const char* kDrvBtnDone = "Done";
const char* kDrvBtnCancel = "Cancel";
const char* kDrvEmptyMsg = "Empty Driver name! Are you sure?";
const char* kDrvMsgCancel = "Cancel";
const char* kDrvMsgOK = "OK";

static void CenterWindowOnScreen(BWindow* w)
{
	BRect	screenFrame = (BScreen(B_MAIN_SCREEN_ID).Frame());
	BPoint 	pt;
	pt.x = screenFrame.Width()/2 - w->Bounds().Width()/2;
	pt.y = screenFrame.Height()/2 - w->Bounds().Height()/2;

	if (screenFrame.Contains(pt))
		w->MoveTo(pt);
}

const int32 kPanelWidth = 260; 
const int32 kPanelHeight = 77;

DriverNamePanel::DriverNamePanel(BCallbackHandler* cb)
	:BWindow(BRect(0,0,kPanelWidth, kPanelHeight), "Driver Name", B_MODAL_WINDOW,  
		B_NOT_RESIZABLE | B_NOT_ZOOMABLE | B_NOT_CLOSABLE)
{	
	m_CallBack = cb;	
	CreatePanelUI();
	
	strcpy(m_DriverName, "");	
	
	Update(kFillControls);
	
	CenterWindowOnScreen(this);
	Show();      
} 

DriverNamePanel::~DriverNamePanel()
{
}

void DriverNamePanel::MessageReceived(BMessage *msg) 
{
 		switch (msg->what){
			case MSG_DONE:
				if (strcmp(m_DriverNameCtl->Text(), "") == 0){
				  BAlert* alert = new BAlert("Driver", kDrvEmptyMsg, 
					   kDrvMsgCancel, kDrvMsgOK, NULL, B_WIDTH_FROM_WIDEST);
		          if (alert->Go() == 0)
					return;
				}
				m_CallBack->Done(B_NO_ERROR);
				PostMessage(B_QUIT_REQUESTED);
			break;
			
			case MSG_CANCEL:
				m_CallBack->Done(B_ERROR);
				PostMessage(B_QUIT_REQUESTED);
			break;
					
		default:
			BWindow::MessageReceived(msg);
			break;
		}
}

void DriverNamePanel::Update(int16 direction)
{		
    // Load up the controls
    if (direction == kFillControls){ 
   		m_DriverNameCtl->SetText(m_DriverName);	       
	}
    else{
        // Fill members from controls
        strcpy(m_DriverName, m_DriverNameCtl->Text());	
    }
}

void DriverNamePanel::CreatePanelUI() 
{
	BRect rect(Bounds());
	rect.InsetBy(-1.0, -1.0);
	m_MainBG = new BBox(rect);
	m_MainBG->SetFont(be_plain_font);
	AddChild(m_MainBG);
	
	rect.left = 11; rect.right = Bounds().Width() - 11;
	rect.top = 13; rect.bottom = 11;
	m_DriverNameCtl = new BTextControl(rect, "", kDrvNameStr, "", NULL);
	m_DriverNameCtl->SetDivider(m_MainBG->StringWidth(kDrvNameStr) + 10);
	m_DriverNameCtl->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
	m_DriverNameCtl->MakeFocus(true);
	BTextView* tv = m_DriverNameCtl->TextView();
	if (tv)
		tv->SetMaxBytes(128);
	m_MainBG->AddChild(m_DriverNameCtl);
	
	rect.right = Bounds().Width() - 10;
	rect.left = rect.right - 75;
	rect.top = m_DriverNameCtl->Frame().bottom + 10;
	rect.bottom = rect.top + 1;
	m_DoneBtn = new BButton(rect, "", kDrvBtnDone, new BMessage(MSG_DONE),
			B_FOLLOW_BOTTOM | B_FOLLOW_RIGHT);
	
	rect.right = rect.left - 10;
	rect.left = rect.right - 75;
	m_CancelBtn = new BButton(rect, "", kDrvBtnCancel, new BMessage(MSG_CANCEL),
			B_FOLLOW_BOTTOM | B_FOLLOW_RIGHT);
	m_MainBG->AddChild(m_CancelBtn);	

	m_MainBG->AddChild(m_DoneBtn);
	SetDefaultButton(m_DoneBtn);
}

void DriverNamePanel::SetDriverName(const char* driverName)
{	
	if (Lock()){
		strcpy(m_DriverName, driverName);		
		Update(kFillControls);
		m_DriverNameCtl->MakeFocus(true);		    		  
    	Unlock();
    }
}

void DriverNamePanel::GetDriverName(char* driverName)
{		
	Update(kEmptyControls);
	strcpy(driverName, m_DriverName);
}

    

