// 	ByteArray.h
//
//	Some helpful methods to read and write values from an
//  array of bytes. Used when working with incoming and outgoing
//  network packets. 
//
//  russ 4/28/99
// 
//	Copyright 1997-1999, Be Incorporated.   All Rights Reserved.
//	This file may be used under the terms of the Be Sample Code License.

#ifndef	_BYTEARRAY_H
#define	_BYTEARRAY_H

inline uint8 readb(char* address) 
{	
	uint8 result;	
	result = *((uint8*)(address));	
	return result;
}

inline uint16 readw(char* address) 
{	
	uint16 result;
	result = *((uint16*)(address));		
	return result;
}

inline uint32 readl(char* address) 
{	
	uint32 result;	
	result = *((uint32*)(address));		
	return result;
}

inline void writeb(uint8 value,  char* address) 
{
	*((uint8*)(address)) = value;
}


inline void writew(uint16 value,  char* address) 
{
	*((uint16*)(address)) = value;
}

inline void writel(uint32 value,  char* address)  
{
	*((uint32*)(address)) = value;
}

// IP checksum method from TCP/IP Illustrated
// V2 by R.Stevens. 
inline uint16 cksum(uchar* pChunk, int32 len)
{
	uint32 sum = 0;
		
	while (len > 1){
		sum += *((uint16*)pChunk);
		pChunk = (uchar*)((uint32)pChunk+2);
		if (sum & 0x80000000)
			sum = (sum & 0xffff) + (sum >> 16);
		len -= 2;
	}
	
	if (len)
		sum += *((uchar*)pChunk);
		
	while (sum >> 16)
		sum = (sum & 0xffff) + (sum >> 16);
		
	return ~sum;		
}

#endif // _BYTEARRAY_H