//******************************************************************************
//
//	File:		pulse.h
//
//	Description:	Header file for RAMPulse(tm)
//
//******************************************************************************

/*
	Copyright 1999, Be Incorporated.   All Rights Reserved.
	This file may be used under the terms of the Be Sample Code License.
*/

#ifndef PULSE_H
#define PULSE_H

#ifndef _APPLICATION_H
#include <Application.h>
#endif
#ifndef _WINDOW_H
#include <Window.h>
#endif
#ifndef _BITMAP_H
#include <Bitmap.h>
#endif
#ifndef _PICTURE_BUTTON_H
#include <PictureButton.h>
#endif
#ifndef _VIEW_H
#include <View.h>
#endif

#include "progressbar.h"

#define	kProcessorOff 200
#define kProcessorOn 	0

extern "C" int  _kget_cpu_state_(int cpu);
extern "C" int  _kset_cpu_state_(int cpu, int enabled);

//#pragma export on

class _EXPORT CPUButton : public BPictureButton {

public:
	enum {
		CPUBUTTON_WIDTH = 17,
		CPUBUTTON_HEIGHT = 17
	};
					CPUButton(BRect r, const char* name, const char* label,
						long cpu, BPicture* normal, BPicture* pushed);
					CPUButton(BMessage *data);
static	CPUButton	*Instantiate(BMessage *data);
virtual	long		Archive(BMessage *data, bool deep = true) const;

virtual	void		Pulse();
virtual void		AttachedToWindow();
virtual void		MessageReceived(BMessage *msg);
virtual status_t	Invoke(BMessage *msg = NULL);
		void		OnOff();

		typedef	BPictureButton _inherited;

private:
		void		InitObject(long cpu);

		bool		fOn;
		long		fCPU;

};

//#pragma export reset

class TPulseView : public BView {
public:
	enum {
		// item margins
		PULSEVIEW_WIDTH = 263,
		PULSEVIEW_MIN_HEIGHT = 82,
		PROGRESS_MLEFT = 101,
		PROGRESS_MTOP = 18,
		PROGRESS_MBOTTOM = 10,
		CPUBUTTON_MLEFT = 79,
		CPUBUTTON_MTOP = 20,
		ITEM_OFFSET = 27
	};
						TPulseView(BRect);
virtual					~TPulseView();
		void			AttachedToWindow();
virtual	void			Draw(BRect updateRect);
		void			Update(bool DoIt = FALSE);
		void			ShowFreeMem(short free);
virtual	void			Pulse();
		void			AddID(uchar*, int32, int32);
static	BRect			CalcViewSize();

		TProgressBar	**fCPUs;
		bigtime_t		fThen;			// time of last udpate

		typedef	BView _inherited;

private:
		system_info		fSysInfo;
		short			fCPUCount;
		CPUButton		**fButtons;
		BBitmap			*fAnim1;

};

class TPulseWindow : public BWindow {
public:
						TPulseWindow(BRect);
		bool			QuitRequested();
		TPulseView		*fPulseView;
};

class PulseApplication : public BApplication {
public:
	PulseApplication(bool mini, int width, bool install,
		rgb_color framecolor, rgb_color activecolor,
		rgb_color idlecolor
		);
};


#endif
