/*
	Copyright 1999, Be Incorporated.   All Rights Reserved.
	This file may be used under the terms of the Be Sample Code License.
*/

// This defines the replicant button

#ifndef __MINIPULSE__
#define __MINIPULSE__

#include <Application.h>
#include <View.h>
#include <Window.h>
#include <View.h>

const rgb_color default_framecolor = {32, 32, 32, 0};
const rgb_color default_idlecolor = {32, 64, 32, 0};
const rgb_color default_activecolor = {32, 192, 32, 0};

//#pragma export on
class _EXPORT MiniPulse;
	// the dragger part has to be exported

class MiniPulse : public BView {
public:
	MiniPulse(BRect frame, const char *name,
		rgb_color n_framecolor,
		rgb_color n_activecolor,
		rgb_color n_idlecolor,
		uint32 resizeMask = B_FOLLOW_LEFT | B_FOLLOW_TOP, 
		uint32 flags = B_WILL_DRAW | B_NAVIGABLE | B_PULSE_NEEDED);
		
	MiniPulse(BMessage *);
		// BMessage * based constructor needed to support archiving
	virtual ~MiniPulse();

	// archiving overrides
	static MiniPulse *Instantiate(BMessage *data);
	virtual	status_t Archive(BMessage *data, bool deep = true) const;

	virtual void AttachedToWindow();	
	virtual void MouseDown(BPoint);
	
	virtual void Pulse();
	virtual void Draw(BRect );

	virtual void MessageReceived(BMessage *);

private:
	virtual void Update();
	int cpu_count;
	double cputime[B_MAX_CPU_COUNT];
	bigtime_t prevactive[B_MAX_CPU_COUNT];
	bigtime_t prevtime;
	rgb_color framecolor;
	rgb_color activecolor;
	rgb_color idlecolor;
};

//#pragma export reset


#endif