#ifndef _PrefsSection_H_
#define _PrefsSection_H_

#include "PrefsDefs.h"

class PrefsSection
{
public:
				 		PrefsSection(PrefsServerType serverType, const char* path);
		virtual			~PrefsSection(void);
		
		// Section State
		bool			IsValid(void);
		bool			ReadOnly(void);

		//	Entries methods
		bool			FindBool(const char* entry, bool defValue = false);
		void			WriteBool(const char* entry, bool value);
		int32			FindInt32(const char* entry, int32 defValue = 0);
		void			WriteInt32(const char* entry, int32 value);
		float			FindFloat(const char* entry, float defValue = 0.0);
		void			WriteFloat(const char* entry, float value);
		BRect			FindRect(const char* entry, BRect defValue = BRect(0.0,0.0,0.0,0.0));
		void			WriteRect(const char* entry, BRect value);
		BPoint			FindPoint(const char* entry, BPoint defValue = BPoint(0.0,0.0));
		void			WritePoint(const char* entry, BPoint value);
		void			FindString(const char* entry, char* value, const uint32 sizeOfValue, const char* defValue = "");
		void			WriteString(const char* entry, const char* value);
		uint32			FindData(const char* entry, void* buffer, const uint32 bufferSize);
		void			WriteData(const char* entry, const void* data, const uint32 len);
		
		// misc
		void			SetMessage(uint32 msgID);
		void			Flush(void);
		void			Reset(bool recursive = true);				
		
		// Advanced methods (mostly used by the PrefsEdit app)
		void			DeleteEntry(const char* entry); 			
		bool			EntryExists(const char* entry, PrefsType* type = NULL); 
		bool			DeleteSection(const char* sectionName);
		void			CreateSection(const char* sectionName);
		uint32			IsSectionInUse(const char* sectionName);
		char*			MallocSectionList(void);		// returns a list of sections
		char*			MallocEntryList(void);			// returns a list of entries

protected:
		uint32			id;
		uint32			validator;
		BMessenger*		server;
		bool			readOnly;
		
		bool			Find(const uint32 type, const char* entry, void* data, const uint32 len);
		void			Write(const uint32 type, const char* entry, const void* value, const uint32 len);
		char*			MallocList(const uint32 msgID);			
};

#endif
