/*
    Class: AnimateCursor
    
    Limitations:
    	This code is provided "as is". The author and/or
    	company is not responsible for any problems encountered
    	from using this class.  In using this class, the
    	developer and/or their company accepts the use of
    	this code in current form.
    
	Author: John Tegen
	Dated: 7 July 1997
	Company: OmicronSoft, (c) All Rights Reserved, 1997
	
	Revision History:
	- 7 July 1997 : Original code
*/

#include <unistd.h>
#include <string.h>
#include "AnimateCursor.h"

#define CURSOR_STREAM_SIZE	68

////////////////////////////////////////////////////
//
AnimateCursor::AnimateCursor( const char *a_name,
							   const int32& a_qty )
{
  strcpy( name, a_name );
  cycle = 0.1;
  qty = a_qty;
  
  //
  // Allocate enougph room for the cursors
  //
  cursors = new unsigned char *[ qty ];
  for( int32 i = 0; i < qty; i++ )
  {
    cursors[i] = new unsigned char[ CURSOR_STREAM_SIZE ];
  }
}

////////////////////////////////////////////////////
//
AnimateCursor::~AnimateCursor( void )
{
  Quit();
  if( qty )
  {
    for( int32 i=0; i < qty; i++ )
    {
      delete [] cursors[i];
    }
    delete [] cursors;
  }
}

////////////////////////////////////////////////////
//
void
AnimateCursor::SetCursor( const int32& a_index,
						   const unsigned char *a_cursor )
{
  //
  // Make certain index is within range
  //
  if( a_index < qty )
  {
    //
    // Save the given cursor to this object
    //
    for( int32 i=0; i < CURSOR_STREAM_SIZE; i++ )
    {
      cursors[a_index][i] = a_cursor[i];
    }
  }
}

////////////////////////////////////////////////////
//
void
AnimateCursor::Run( float a_cycle )
{
  //
  // If no name was given, don't run the thread
  //
  if( !strlen( name ) )return;
  
  //
  // Set the cycle is positive
  //
  if( a_cycle > 0.0 )cycle = a_cycle;
  
  //
  // Spawn thread
  //
  thrd = spawn_thread( RunLoop, name,
  						B_LOW_PRIORITY, this );
  resume_thread( thrd );
}

////////////////////////////////////////////////////
//
int32
AnimateCursor::RunLoop( void * a_arg )
{
  AnimateCursor *obj = (AnimateCursor *)a_arg;
  return obj->LoopCursors();
}

////////////////////////////////////////////////////
//
int32
AnimateCursor::LoopCursors( void )
{  
  while( 1 )
  {
    for( int32 i=0; i < qty; i++ )
    {
      be_app->SetCursor( cursors[i] );
      snooze( cycle * 1000000.0 );		// snooze in miliseconds
    }
  }
  return 0;
}

////////////////////////////////////////////////////
//
void
AnimateCursor::Suspend( void )
{
  suspend_thread( thrd );
  be_app->SetCursor( B_HAND_CURSOR );
}

////////////////////////////////////////////////////
//
void
AnimateCursor::Resume( float a_cycle )
{
  if( a_cycle > 0.0 )
  {
    cycle = a_cycle;
  }
  resume_thread( thrd );
}

////////////////////////////////////////////////////
//
void
AnimateCursor::Quit( void )
{
  kill_thread( thrd );
  be_app->SetCursor( B_HAND_CURSOR );
}

////////////////////////////////////////////////////
//
bool
AnimateCursor::IsRunning( void )
{
  thread_info info;
  if( get_thread_info( thrd, &info ) == B_OK )
  {
    return( info.state == B_THREAD_RUNNING ||
            info.state == B_THREAD_ASLEEP );
  }
  else
  {
    return FALSE;
  }
}
