#include <stdio.h>
#include <app/Application.h>
#include <interface/InterfaceDefs.h>
#include "ColorMap.h"

int main( void )
{
	BApplication app( '????' );

	ColorMap map;

	color_map *c = system_colors();

	printf( "Here come the nearest greyscale equivalents for the system colours:\n" );

	for( unsigned int loop = 0; loop < 256; loop++ ) {
		// Yes, I know this is a super-naive way of calculating the
		// greyscale value for an r,g,b; I couldn't find the real
		// equation on/in my desk/notebooks, and I didn't feel like
		// snooping around the 'net for a gimpy test program.
		unsigned char grey = ( c->color_list[loop].red 
							 + c->color_list[loop].green
							 + c->color_list[loop].blue ) / 3;

		unsigned int index = map.getIndex( grey, grey, grey );
		rgb_color    new_c = map.getColor( grey, grey, grey );

		printf( "[%3d,%3d,%3d] = [%3d grey] = %3d:[%3d,%3d,%3d]\n",
			    c->color_list[loop].red,
			    c->color_list[loop].green,
			    c->color_list[loop].blue,
			    grey,
			    index,
			    new_c.red,
			    new_c.blue,
			    new_c.green );
	}

	app.PostMessage( B_QUIT_REQUESTED );
	app.Run();

	return B_NO_ERROR;
}
