/*****************************************************************************

	Projet	: Pulsar Sample AddOn

	Fichier	: sample_addon.cpp
	Partie	: End

	Auteur	: RM
	Date		: 040597 -- version 0.2 (C funcs)
	Date		: 010797 -- version 0.3 (CFilter)
	Format	: tabs==2

	This Sample Add-on does nothing. It is just a skeleton that you may use
	for building add-on.

	The simple way to do this :
	- implement & export the C function "CFilter * filterInit(uint32 index)",
	  where  you simply create your CFilter derived class.
	- derive a class from CFilter, you should at least implement two methods
	- CFilter::load() must be implemented, this is where you will fill info about
	  your add-on, name, auhtor, etc. You DON'T need to call the inherited function,
	  it does nothing.
	- CFilter::processFrame() is where you draw the output, by using the info about
	  the sound and the stream.

	You can enhance this usage by implementing the other methods :
	- unload() called just before the add-on image is unloaded, the next call will be
	  the destructor.
	- prepare() is called just before the stream goes on, thus after load() but before
	  processFrame(). You can cache some info, as you may need.
	- terminate() is called when the stream is stopped, thus after any processFrame()
	  but before unload().

	The function always get called like this :
	- filterInit(), called once
	- constructor(), called once
	- load(), called once
	- loop :
			- prepare()
					- loop : several processFrame(), up to 60 or 90 Hz...
			- terminate()
	- unload()
	- destructor()
	- image unloaded.

*****************************************************************************/

#include "CFilter.h"

#pragma export on
CFilter * filterInit(uint32 index);
#pragma export reset

//--------------------------------------------------------------------

//**********************************
class CSampleFilter : public CFilter
//**********************************
{
public:

	CSampleFilter(void) : CFilter()	{ printf("constructor SampleFilter %p\n", this);}
	virtual ~CSampleFilter(void) 			{ printf("destructor SampleFilter %p\n", this);}

	virtual bool load(void);
	virtual bool prepare(void);
	virtual void processFrame(void);
	virtual void terminate(void);
	virtual void unload(void);

private:
	// nothing yet

}; // end of class defs for CSampleFilter


//--------------------------------------------------------------------


//**********************************************
CFilter * filterInit(uint32 index)
//**********************************************
/*
	This function is called when the add-on is loaded.
	This occurs when Pulsar is starting.
	This function is called several times with index=0 then 1 etc
	until it returns NULL. This give you the opportunity to code
	several filters in one add-on.

	Here you must create a new instance of your derived CFilter class.
	You return the pointer on the instance.
	You get called several times until you return NULL.
	You must return a valid object pointer, since the caller will verify
	using ClassInfo that the class is derived from CFilter but is not a
	CFilter instance.
*/
{
	printf("filterInit -- index %d\n", index);

	// this add-on only declares ONE filter
	if (index > 0) return NULL;

	CSampleFilter *info = new CSampleFilter;
	if (!info) return NULL;		// memory error, give up

	// returns the instance -- the caller will check that this instance
	// is derived from CFilter but is _not_ a CFilter...
	printf("new info %p, class %s\n", info, class_name(info));
	return info;
} // end of filterInit


//****************************
bool CSampleFilter::load(void)
//****************************
/*
	Called just after the add-on has succesfully been loaded.
	If you return false, <the add-on will be unloaded immediatly
	and its unload() hook will be called>.
	Use this to set up the vital info about the filter, i.e. the
	strings (optional) and the supported color mode (currently fixed to 8 bits).
	This can also be done in you class constructor.
	The main difference with the constructor is that when you get here,
	the main program will have set up your main members, like the directories,
	the pointers onto buffers, etc. Also you can get back the index of the
	instance indicated by filterInit here. Check the CFilter.h for more info ;-)
*/
{
	printf("CSampleFilter::load\n");
	sFilter.name = "Sample Addon";
	sFilter.author = "R'alf";
	sFilter.info = "Sample code";
	sFilter.majorVersion = 0;
	sFilter.minorVersion = 3;

	// the next line is foolish. I must look at datatype first.
	return(sLoad.majorPulsarVersion == sFilter.majorVersion
			&& sLoad.minorPulsarVersion == sFilter.minorVersion);
}  // end of load for CSampleFilter


//******************************
void CSampleFilter::unload(void)
//******************************
/*
	Called just before the add-on is unloaded, when the
	program quits.
	<At this time, the followings fields are valid :
	sx, sy, sxy, bpr, screen, mode, rawH/B, fftH/B>
*/
{
	printf("CSampleFilter::unload\n");
}  // end of unload for CSampleFilter


//*******************************
bool CSampleFilter::prepare(void)
//*******************************
/*
	Called when the user wants to make the view pulse.
	Give a chance to the filter to alloc memory or compute
	some tables.
	<At this time, the followings fields are valid :
	sx, sy, sxy, bpr, screen, mode, rawH/B, fftH/B>
	If you return false, the filter won't participate. <TBD>

	NO THESE ARE NO LONGER CONSTANT !
	I WIL SWITCH TO DOUBLE BUFFER IN 0.4 !!
*/
{
	printf("CSampleFilter::prepare\n");
	return true;
}  // end of prepare for CSampleFilter


//*********************************
void CSampleFilter::terminate(void)
//*********************************
/*
	Called when the user wants to stop pulse the view.
	Give a chance to the filter to free memory.
*/
{
	printf("CSampleFilter::terminate\n");
}  // end of terminate for CSampleFilter


//************************************
void CSampleFilter::processFrame(void)
//************************************
/*
	Real blit into the screen.
	<Updated fields : frame, lastFps>

	Warning !
	NO THESE ARE NO LONGER CONSTANT !
	I WIL SWITCH TO DOUBLE BUFFER IN 0.4 !!
	TBD : update comment !!!
*/
{
	printf("CSampleFilter::processFrame\n");
}  // end of processFrame for CSampleFilter


// eoc
