/*****************************************************************************

	Projet	: Pulsar

	Fichier	:	CFilter.cpp
	Partie	: Add-ons for filters

	Auteur	: RM
	Format	: tabs==2

*****************************************************************************/

#include "CFilter.h"
#include "GetBitmap.h"
#include <Path.h>

//---------------------------------------------------------------------------

//***********************************************************************
void CFilter::blitLine(long x1, long y1, long x2, long y2, uchar couleur)
//***********************************************************************
// draws a line in the current buffer using bresenham simple pass algorithm.
// (if you have the double algorithm at hand, I take it, I'm just _that_ lazy
// to write it down...)
// do not call this if screen, sx, sy & bpr are NOT correct.
// clips the line agains the screen size.
{
register uchar *dest = this->sFrame.screen;
register uchar *p;
register long bpr = this->sPrepare.bpr;
register long msx = this->sPrepare.sx;
register long msy = this->sPrepare.sy;

//-----------------------------------------
// this code is extracted from ST Magazine and was originally asm 68k.
register int dx, dy, t1, t2, t3, x, y, sy, w;
sy = 1;

	#define M_SWAP(x,y) { w=x; x=y; y=w; }

	if (y1 == y2)
	{
		//--- horizontal line ---

		if (x1 > x2) M_SWAP(x1, x2);
		
		// clipping
		if (x2 >= 0 && x1 < msx && y1 >= 0 && y1 < msy) 
		{
			if (x1 < 0) x1 = 0;
			if (x2 >= msx) x2 = msx-1;

			for (x = x1, p=dest+x+bpr*y1; x <= x2; x++) *(p++) = couleur;
		}
	}
	else if ( (dx = x2 - x1) == 0)
	{
		//--- vertical line ---

		if (y1 > y2) M_SWAP(y1, y2);
		
		// clipping
		if (y2 >= 0 && y1 < msy && x1 >= 0 && x1 < msx)
		{
			if (y1 < 0) y1 = 0;
			if (y2 >= msy) y2 = msy-1;
			
			for (y = y1, p=dest+x1+bpr*y; y <= y2; y++, p+=bpr) *p = couleur;
		}
	}
	else
	{
		if (dx >= 0)
		{
			x = x1;
			y = y1;
			dy = y2 - y1;
		}
		else
		{
			x = x2;
			y = y2;
			dx = -dx;
			dy = y1 - y2;
		}

		if (dy <= 0)
		{
			dy = -dy;
			sy = -1;
		}

		if (dx >= dy)
		{
			t3 = dy << 1;
			t1 = t3 - dx;
			t2 = t1 - dx;

			p = dest+x+bpr*y;
			for (; dx >= 0; x++, dx--, p++)
			{
				if (y >= 0 && y < msy && x >= 0 && x < msx) *p = couleur;

				if (t1 < 0)
					t1 += t3;
				else
				{
					t1 += t2;
					y += sy;
					p += bpr*sy;
				}
			}
		}
		else
		{
			t3 = dx << 1;
			t1 = t3 - dy;
			t2 = t1 - dy;

			p = dest+x+bpr*y;
			for (; dy >= 0; y+=sy, dy--, p+=bpr*sy)
			{
				if (y >= 0 && y < msy && x >= 0 && x < msx) *p = couleur;

				if (t1 < 0)
					t1 += t3;
				else
				{
					t1 += t2;
					x++;
					p++;
				}
			}
		}
	}

	#undef M_SWAP

} // end of blitLine for CFilter

//***********************************************************************
bool CFilter::findDir(BDirectory *dir, char *name)
//***********************************************************************
// find a directory by name under the Application directory
// returns false if directory can't be found
{
	if (!dir) return false;
	if (!name || strlen(name) < 1) return false;
	return (dir->SetTo(&sLoad.dirApplication, name) >= B_NO_ERROR);
} // end of findDir for CFilter

//***********************************************************************
BBitmap * CFilter::loadBitmap(char *name)
//***********************************************************************
// use datatypes to open the 'name' image in the img directory
// returns NULL if error.
{
BPath path(&sLoad.dirImg,name);

	return GetBitmap(path.Path());

} // end of blitLine for CFilter


//***********************************************************************
BBitmap *CFilter::makeIconFromHeader(
						int width, int height,
						color_space cspace,
						int bytesperpixel,
						unsigned char *bits)
//***********************************************************************
{
BBitmap *bitmap = new BBitmap(BRect(0,0,width-1, height-1), cspace);
	if (!bitmap) return NULL;
	int bpr = bytesperpixel*width;
	int destbpr = bitmap->BytesPerRow();
	int offset=0, destof7=0;
	int j;
	for(j=0; j<height; j++, offset+=bpr, destof7+=destbpr)
		bitmap->SetBits(bits+destof7, bpr, offset, cspace);
	return bitmap;
} // end of blitLine for CFilter

// eocpp

