/*****************************************************************************

	Projet	: Pulsar Sample Demicercle AddOn

	Fichier	: sample_addon.cpp
	Partie	: End

	Auteur	: RM
	Date		: 040597 -- version 0.2 (C funcs)
	Date		: 010797 -- version 0.3 (CFilter)
	Format	: tabs==2

	This Sample FFT Add-on does something : blit the two fft on screen.
	This is a hack.

	The simple way to do this :
	- implement & export the C function "CFilter * filterInit(uint32 index)",
	  where  you simply create your CFilter derived class.
	- derive a class from CFilter, you should at least implement two methods
	- CFilter::load() must be implemented, this is where you will fill info about
	  your add-on, name, auhtor, etc. You DON'T need to call the inherited function,
	  it does nothing.
	- CFilter::processFrame() is where you draw the output, by using the info about
	  the sound and the stream.

*****************************************************************************/


#include "CFilter.h"
#include "fastmath.h"

#pragma export on
CFilter * filterInit(uint32 index);
#pragma export reset

//--------------------------------------------------------------------

//****************************************
class CSampleCercleFilter : public CFilter
//****************************************
{
public:

	CSampleCercleFilter(void) : CFilter()	{ /* nothing */ }
	virtual ~CSampleCercleFilter(void) 		{ /* nothing */ }

	virtual bool load(void);
	virtual bool prepare(void) { return true; } // don't miss that call !
	virtual void processFrame(void);

}; // end of class defs for CSampleCercleFilter


//--------------------------------------------------------------------


//********************************
CFilter * filterInit(uint32 index)
//********************************
/*
	This function is called when the add-on is loaded.
	This occurs when Pulsar is starting.
	This function is called several times with index=0 then 1 etc
	until it returns NULL. This give you the opportunity to code
	several filters in one add-on.

	Here you must create a new instance of your derived CFilter class.
	You return the pointer on the instance.
	You get called several times until you return NULL.
	You must return a valid object pointer, since the caller will verify
	using ClassInfo that the class is derived from CFilter but is not a
	CFilter instance.
*/
{
	// this add-on only declares ONE filter
	if (index > 0) return NULL;

	CSampleCercleFilter *info = new CSampleCercleFilter;
	if (!info) return NULL;		// memory error, give up

	// returns the instance -- the caller will check that this instance
	// is derived from CFilter but is _not_ a CFilter...
	return info;
} // end of filterInit


//**********************************
bool CSampleCercleFilter::load(void)
//**********************************
/*
	Called just after the add-on has succesfully been loaded.
	If you return false, <the add-on will be unloaded immediatly
	and its unload() hook will be called>.
	Use this to set up the vital info about the filter, i.e. the
	strings (optional) and the supported color mode (currently fixed to 8 bits).
	This can also be done in you class constructor.
	The main difference with the constructor is that when you get here,
	the main program will have set up your main members, like the directories,
	the pointers onto buffers, etc. Also you can get back the index of the
	instance indicated by filterInit here. Check the CFilter.h for more info ;-)
*/
{
	sFilter.name = "Loupe Addon";
	sFilter.author = "R'alf";
	sFilter.info = "Sample code";
	sFilter.majorVersion = 0;
	sFilter.minorVersion = 3;

	return(sLoad.majorPulsarVersion == sFilter.majorVersion
			&& sLoad.minorPulsarVersion == sFilter.minorVersion);
}  // end of load for CSampleCercleFilter


//******************************************
void CSampleCercleFilter::processFrame(void)
//******************************************
/*
	Real blit into the screen.
	<Updated fields : frame, lastFps>

	Bad implementation, may be *that* slow...

	Warning !
	NO THESE ARE NO LONGER CONSTANT !
	I WIL SWITCH TO DOUBLE BUFFER IN 0.4 !!
*/
{
float *chanL;
float *chanR;
int i;
//int j;
uchar *base;
long bpr;
long frame;
int y1;
int y2;
//int h = info->sy;
//int w = info->sx;
//int w2 = w/2;
//int h2 = h/2;

	base 	= sFrame.screen;
	bpr		= sPrepare.bpr;
	frame	= sFrame.frame;
	chanL = sFrame.fftHigh;
	chanR = sFrame.fftBass;

	// demi cercles

	const float inc_pi = 3.1415926538/2/64;
	float angle=0;
	for(i=0; i<64; i++, angle+=inc_pi)
	{
		float rx = inl_b_cos_90(angle);
		float ry = inl_b_cos_90(3.1415926538/2-angle);
		long x1=150+128*rx;
		y1=     200-128*ry;
		y2=chanL[i]/16384;
		long x2=150+(128-y2)*rx;
		y2=     200-(128-y2)*ry;

		blitLine(x1,y1,x2,y2,i+frame);
	}

	for(angle=0, i=0; i<64; i++, angle+=inc_pi)
	{
		float rx = inl_b_cos_90(angle);
		float ry = inl_b_cos_90(3.1415926538/2-angle);
		long x1=450+50*rx;
		y1=     300-50*ry;
		y2=chanR[i]/16384;
		long x2=450+(60+y2)*rx;
		y2=     300-(60+y2)*ry;

		blitLine(x1,y1,x2,y2,i+frame);
	}

}  // end of processFrame for CSampleCercleFilter


// eoc
