#ifndef __DEBUGGING_ALLOCATOR__
#define __DEBUGGING_ALLOCATOR__

#if DEBUG

#define LEAK_CHECKING
	// this turns leak checking on and off in debug builds

#pragma export on

#ifdef __cplusplus
extern "C" {
#endif

void record_new(void *, size_t);
void record_delete(void *);

void record_malloc(void *, size_t);
void record_free(void *);
void record_realloc(void *, void *, size_t);

_IMPEXP_ROOT bool NewLeakChecking();
_IMPEXP_ROOT void SetNewLeakChecking(bool);
_IMPEXP_ROOT void DumpNewLeakCheckTable();

_IMPEXP_ROOT bool MallocLeakChecking();
_IMPEXP_ROOT void SetMallocLeakChecking(bool);
_IMPEXP_ROOT void DumpMallocLeakCheckTable();

_IMPEXP_ROOT void *unchecked_malloc(size_t);
_IMPEXP_ROOT void *unchecked_realloc(void *, size_t);
_IMPEXP_ROOT void unchecked_free(void *);

#ifdef __cplusplus
}
#endif

#pragma export reset


#endif
#endif