

#if !defined(_TS_EVENT_LOOPER_H)
#define _TS_EVENT_LOOPER_H

#include <TimeSource.h>
#include <MediaEventLooper.h>

class BTSEventLooper :
	public BTimeSource,
	public BMediaEventLooper
{
	protected:
		/* this has to be on top rather than bottom to force a vtable in mwcc */
		virtual				~BTSEventLooper();
							BTSEventLooper();
		
		virtual void		DispatchTimeSourceEvent(
											bigtime_t offset,
											bigtime_t performanceTime,
											int32 what,
											void *pointer,
											uint32 cleanup,
											int64 data);
		
	private:
		/* you must override to handle your time source events! */
		virtual void		HandleTimeSourceEvent(
											bigtime_t offset,
											bigtime_t realTime,
											int32 what,
											void *pointer,
											uint32 cleanup,
											int64 data) = 0;
											
		BTimedEventQueue *	RTEventQueue();

	/* BTimeSource */
	protected:
		virtual	status_t 	TimeSourceOp(const time_source_op_info & op, void * _reserved);
		
	/* BMediaEventLooper */
	private:
		virtual void		ControlLoop();			

		BTimedEventQueue	_mRTEventQueue;
		
	private:
	/* unimplemented for your protection */
							BTSEventLooper(const BTSEventLooper&);
							BTSEventLooper& operator=(const BTSEventLooper&);

	/* fragile base class stuffing */
	private:	
		/* it must be thanksgiving!! lots of stuffing! */
		virtual	status_t 	_Reserved_BTSEventLooper_0(int32 arg, ...);
		virtual	status_t 	_Reserved_BTSEventLooper_1(int32 arg, ...);
		virtual	status_t 	_Reserved_BTSEventLooper_2(int32 arg, ...);
		virtual	status_t 	_Reserved_BTSEventLooper_3(int32 arg, ...);
		virtual	status_t 	_Reserved_BTSEventLooper_4(int32 arg, ...);
		virtual	status_t 	_Reserved_BTSEventLooper_5(int32 arg, ...);
		virtual	status_t 	_Reserved_BTSEventLooper_6(int32 arg, ...);
		virtual	status_t 	_Reserved_BTSEventLooper_7(int32 arg, ...);
		virtual	status_t 	_Reserved_BTSEventLooper_8(int32 arg, ...);
		virtual	status_t 	_Reserved_BTSEventLooper_9(int32 arg, ...);
		virtual	status_t 	_Reserved_BTSEventLooper_10(int32 arg, ...);
		virtual	status_t 	_Reserved_BTSEventLooper_11(int32 arg, ...);
		virtual	status_t 	_Reserved_BTSEventLooper_12(int32 arg, ...);
		virtual	status_t 	_Reserved_BTSEventLooper_13(int32 arg, ...);
		virtual	status_t 	_Reserved_BTSEventLooper_14(int32 arg, ...);
		virtual	status_t 	_Reserved_BTSEventLooper_15(int32 arg, ...);
		virtual	status_t 	_Reserved_BTSEventLooper_16(int32 arg, ...);
		virtual	status_t 	_Reserved_BTSEventLooper_17(int32 arg, ...);
		virtual	status_t 	_Reserved_BTSEventLooper_18(int32 arg, ...);
		virtual	status_t 	_Reserved_BTSEventLooper_19(int32 arg, ...);
		virtual	status_t 	_Reserved_BTSEventLooper_20(int32 arg, ...);
		virtual	status_t 	_Reserved_BTSEventLooper_21(int32 arg, ...);
		virtual	status_t 	_Reserved_BTSEventLooper_22(int32 arg, ...);
		virtual	status_t 	_Reserved_BTSEventLooper_23(int32 arg, ...);

		/* turkey for weeks! */
		uint32 				_reserved_BTSEventLooper_[12];

};

#endif
