/******************************************************************************

	File: SoundFile.h

	Description:	Interface for a format-insensitive sound file object.

	Copyright 1995-99, Be Incorporated

******************************************************************************/


#ifndef _SOUND_FILE_H
#define _SOUND_FILE_H

#ifndef _BE_BUILD_H
#include <BeBuild.h>
#endif
#include <MediaDefs.h>
#include <Entry.h>
#include <File.h>

enum  /* sound_format*/
{ B_UNKNOWN_FILE, 
  B_AIFF_FILE, 
  B_WAVE_FILE, 
  B_UNIX_FILE };

class BMediaFile;
class BMediaTrack;
class BEntry;
class BFile;

class BSoundFile  {

public:
					BSoundFile();
					BSoundFile(const entry_ref *ref,
							   uint32 open_mode);
	virtual			~BSoundFile();

	status_t		InitCheck() const;

	status_t		SetTo(const entry_ref *ref, uint32 open_mode);

	int32			FileFormat() const;
	int32			SamplingRate() const;
	int32			CountChannels() const;
	int32			SampleSize() const;
	int32			ByteOrder() const;
	int32			SampleFormat() const;
	int32			FrameSize() const;
	off_t			CountFrames() const;

	bool			IsCompressed() const;
	int32			CompressionType() const;
	char	 		*CompressionName() const;

	virtual int32 	SetFileFormat(int32 format);
	virtual int32	SetSamplingRate(int32 fps);
	virtual int32	SetChannelCount(int32 spf);
	virtual int32	SetSampleSize(int32 bps);
	virtual int32	SetByteOrder(int32 bord);
	virtual int32	SetSampleFormat(int32 fmt);
private:
	virtual int32	SetCompressionType(int32 type);
	virtual char   	*SetCompressionName(char *name);
	virtual bool	SetIsCompressed(bool tf);
	virtual	off_t	SetDataLocation(off_t offset);	//	deprecated
	virtual off_t	SetFrameCount(off_t count);		//	deprecated
public:
	
	size_t			ReadFrames(char *buf,  size_t count);
	size_t			WriteFrames(char *buf, size_t count);
	virtual off_t	SeekToFrame(off_t n);
	off_t 			FrameIndex() const;
	off_t			FramesRemaining() const;

private:

	void			_init();

	BFile			*_m_legacyFile;

virtual	void		_ReservedSoundFile1();
virtual	void		_ReservedSoundFile2();
virtual	void		_ReservedSoundFile3();

	BEntry *		_m_entry;
	BMediaFile *	_m_file;
	BMediaTrack *	_m_track;
	uchar			_m_byteOrder;	//	media kit namespace
	uchar			_m_accessMode;
	uchar			_m_reserved_0[2];
	size_t			_m_bufSize;
	size_t			_m_bufLeft;
	size_t			_m_bufThere;
	size_t			_m_reserved_1[1];
	off_t			_m_frameCount;
	off_t			_reserved_2[1];
	
	bool			_m_writing;
	uchar			_m_sampleFormat;
	uchar			_m_sampleSize;
	uchar			_m_channelCount;
	float			_m_frameRate;
	char *			_m_tempBuf;
	status_t		_m_initStatus;
//	void _init_raw_stats();
//	status_t _ref_to_file(const entry_ref *ref);	  
	uint32			_reserved[4];
};


#endif			/* #ifndef _SOUND_FILE_H*/
