#include <Debug.h>
#include <Message.h>
#include "DProxy.h"
#include <stdlib.h>
#include <stdio.h>

extern "C" status_t DumpVariable(DProxy& proxy);


class TmpStorage {
public:
	TmpStorage()
		:	ptr(0)
		{}
	~TmpStorage()
		{ free(ptr); }
		
	void *Use(size_t size)
		{
			free(ptr);
			return malloc(size);
		}

private:
	void *ptr;
};

// cruft from Message.cpp

struct dyn_array {
	int32 fLogicalBytes;
	int32 fPhysicalBytes;
	int32 fChunkSize;
	int32 fCount;
	int32 fEntryHdrSize;	
};

struct entry_hdr : public dyn_array {
	entry_hdr *fNext;
	uint32 fType;
	uchar fNameLength;	
	char fName[1];
};

struct var_chunk {
	int32 fDataSize;				
	char fData[1];
};

// overlay to help walking a message
struct DebugMessagOverlay {
	uint32 what;
	BMessage *link;
	int32 fTarget;	
	BMessage *fOriginal;
	uint32 fChangeCount;
	int32 fCurSpecifier;
	uint32 fPtrOffset;
	uint32 _reserved[3];

	entry_hdr *fEntries;

	struct {
		port_id port;
		int32 target;
		team_id team;
		bool preferred;
	} fReplyTo;

	bool fPreferred;
	bool fReplyRequired;
	bool fReplyDone;
	bool fIsReply;
	bool fWasDelivered;
	bool fReadOnly;
	bool fHasSpecifiers;	
};

// more cruft from Message.cpp

#define convert(a) 	((a)?(entry_hdr *)(((uint32)(a)) + fPtrOffset) : 0)	

inline char *
da_start_of_data(DProxy& proxy, const dyn_array *realEntry, const dyn_array *mappedEntry,
	TmpStorage &tmp)
{
	uint32 alignedSize = ((mappedEntry->fChunkSize * mappedEntry->fCount + 3) >> 2) << 2;
	char *result = (char *)tmp.Use(alignedSize);
	
	if (proxy.ReadData((ptr_t)((char *)realEntry) + (sizeof(dyn_array) + mappedEntry->fEntryHdrSize),
		result, alignedSize) != B_OK) {
		printf("error reading entry data from addr %px, size %d, entry %px, headerSize %ld\n",
			((char *) realEntry) + (sizeof(dyn_array) + mappedEntry->fEntryHdrSize),
			alignedSize, realEntry, mappedEntry->fEntryHdrSize);
		return 0;
	}
	return result;
}

inline var_chunk *
da_first_chunk(DProxy& proxy, const dyn_array *realEntry, const dyn_array *mappedEntry,
	TmpStorage &tmp)
{
	return (var_chunk *) da_start_of_data(proxy, realEntry, mappedEntry, tmp);
}

inline int32
da_chunk_hdr_size()
{
	return sizeof(int32);
}

inline int32
da_chunk_size(var_chunk *v)
{
	return (v->fDataSize + da_chunk_hdr_size() + 7) & ~7;
}

inline var_chunk *
da_next_chunk(DProxy& proxy, var_chunk *v, TmpStorage &tmp)
{
	TRESPASS();
	return (var_chunk *) (((char*) v) + da_chunk_size(v));
}

status_t DumpVariable(DProxy& proxy)
{
	ptr_t addr = proxy.VariableAddress();
	
	if (proxy.IsPointer())
	{
		proxy.Dereference();
		addr = proxy.VariableAddress();
	}
	
	size_t size = proxy.VariableSize();
	void *p = malloc(size);
	if (p && proxy.ReadData (addr, p, size) == B_OK)
	{

		const char *spaces =
	//   112345678921234567893123456789412345678951234567896
		"                                                   ";
		int	sl = strlen(spaces);

		union {
			uint32 value;
			char string[4];
		} swappedValue;
		
		char buffer[256];

		DebugMessagOverlay *message = reinterpret_cast<DebugMessagOverlay *>(p);
		swappedValue.value = B_BENDIAN_TO_HOST_INT32(message->what);
		const char *messageWhat = 0;
		switch (message->what) {
			case B_ABOUT_REQUESTED:
				messageWhat = "B_ABOUT_REQUESTED";
				break;
			case B_WINDOW_ACTIVATED:
				messageWhat = "B_WINDOW_ACTIVATED";
				break;
//			case B_APP_ACTIVATED:
//				messageWhat = "B_APP_ACTIVATED";
//				break;
			case B_ARGV_RECEIVED:
				messageWhat = "B_ARGV_RECEIVED";
				break;
			case B_QUIT_REQUESTED:
				messageWhat = "B_QUIT_REQUESTED";
				break;
//			case B_CLOSE_REQUESTED:
//				messageWhat = "B_CLOSE_REQUESTED";
//				break;
			case B_CANCEL:
				messageWhat = "B_CANCEL";
				break;
			case B_KEY_DOWN:
				messageWhat = "B_KEY_DOWN";
				break;
			case B_KEY_UP:
				messageWhat = "B_KEY_UP";
				break;
			case B_MODIFIERS_CHANGED:
				messageWhat = "B_MODIFIERS_CHANGED";
				break;
			case B_MINIMIZE:
				messageWhat = "B_MINIMIZE";
				break;
			case B_MOUSE_DOWN:
				messageWhat = "B_MOUSE_DOWN";
				break;
			case B_MOUSE_MOVED:
				messageWhat = "B_MOUSE_MOVED";
				break;
			case B_MOUSE_ENTER_EXIT:
				messageWhat = "B_MOUSE_ENTER_EXIT";
				break;
			case B_MOUSE_UP:
				messageWhat = "B_MOUSE_UP";
				break;
			case B_OPEN_IN_WORKSPACE:
				messageWhat = "B_OPEN_IN_WORKSPACE";
				break;
			case B_PULSE:
				messageWhat = "B_PULSE";
				break;
			case B_READY_TO_RUN:
				messageWhat = "B_READY_TO_RUN";
				break;
			case B_REFS_RECEIVED:
				messageWhat = "B_REFS_RECEIVED";
				break;
			case B_SCREEN_CHANGED:
				messageWhat = "B_SCREEN_CHANGED";
				break;
			case B_VALUE_CHANGED:
				messageWhat = "B_VALUE_CHANGED";
				break;
			case B_VIEW_MOVED:
				messageWhat = "B_VIEW_MOVED";
				break;
			case B_VIEW_RESIZED:
				messageWhat = "B_VIEW_RESIZED";
				break;
			case B_WINDOW_MOVED:
				messageWhat = "B_WINDOW_MOVED";
				break;
			case B_WINDOW_RESIZED:
				messageWhat = "B_WINDOW_RESIZED";
				break;
			case B_WORKSPACES_CHANGED:
				messageWhat = "B_WORKSPACES_CHANGED";
				break;
			case B_WORKSPACE_ACTIVATED:
				messageWhat = "B_WORKSPACE_ACTIVATED";
				break;
			case B_ZOOM:
				messageWhat = "B_ZOOM";
				break;
			case _APP_MENU_:
				messageWhat = "_APP_MENU_";
				break;
			case _BROWSER_MENUS_:
				messageWhat = "_BROWSER_MENUS_";
				break;
			case _MENU_EVENT_:
				messageWhat = "_MENU_EVENT_";
				break;
			case _PING_:
				messageWhat = "_PING_";
				break;
			case _QUIT_:
				messageWhat = "_QUIT_";
				break;
			case _VOLUME_MOUNTED_:
				messageWhat = "_VOLUME_MOUNTED_";
				break;
			case _VOLUME_UNMOUNTED_:
				messageWhat = "_VOLUME_UNMOUNTED_";
				break;
			case _MESSAGE_DROPPED_:
				messageWhat = "_MESSAGE_DROPPED_";
				break;
			case _DISPOSE_DRAG_:
				messageWhat = "_DISPOSE_DRAG_";
				break;
			case _MENUS_DONE_:
				messageWhat = "_MENUS_DONE_";
				break;
			case _SHOW_DRAG_HANDLES_:
				messageWhat = "_SHOW_DRAG_HANDLES_";
				break;
			case _EVENTS_PENDING_:
				messageWhat = "_EVENTS_PENDING_";
				break;
			case _UPDATE_:
				messageWhat = "_UPDATE_";
				break;
			default:
				break;
		}
		
		if (messageWhat)
			printf("BMessage: what = \'%s\' (0x%lx)\n", messageWhat,
				message->what);
		else
			printf("BMessage: what = \'%.4s\' (0x%lx, or %li)\n", swappedValue.string, 
				message->what, message->what);
		
		uint32 fPtrOffset = message->fPtrOffset;
		entry_hdr *fEntries = message->fEntries;
		const entry_hdr *entry = convert(fEntries);
		while (entry) {
			entry_hdr tmp;
			if (proxy.ReadData((ptr_t)entry, &tmp, sizeof(tmp)) != B_OK)
				break;
			
			uint32 newSize = sizeof(tmp) + tmp.fNameLength;
			entry_hdr *newEntry = (entry_hdr *)malloc(newSize);
			if (proxy.ReadData((ptr_t)entry, newEntry, newSize) != B_OK) {
				free(newEntry);
				break;
			}

			const entry_hdr *mappedEntry = newEntry;

			swappedValue.value = B_BENDIAN_TO_HOST_INT32(mappedEntry->fType);
			sprintf(buffer, "    entry %14s, type=\'%.4s\', c=%li, size=%2li, ",
				mappedEntry->fName, swappedValue.string, mappedEntry->fCount,
				mappedEntry->fChunkSize);
			
			int offset = strlen(buffer);
			printf(buffer);

			TmpStorage store;
			switch (mappedEntry->fType) {
				case B_STRING_TYPE: {
					var_chunk *vc = da_first_chunk(proxy, entry, mappedEntry, store);
					if (vc)
						for (int32 i = 0; i < mappedEntry->fCount; i++) {
							TmpStorage store;
							printf("%sdata[%li]: \"%s\"\n",
								i > 0 ? spaces + sl - offset : "", i,
								vc->fData);
							// for now bail
							break;
//							vc = da_next_chunk(proxy, entry, mappedEntry, store);
						}
					break;
				}
				case B_BOOL_TYPE: {
					bool *val = (bool*)da_start_of_data(proxy, entry, mappedEntry, store);
					if (val)
						for (int32 i = 0; i < mappedEntry->fCount; i++) {
							printf("%sdata[%li]: %d\n",
								i > 0 ? spaces + sl - offset : "", i, *val);
							val++;
						}
					break;
				}
				case B_INT32_TYPE: {
					int32 *val = (int32*)da_start_of_data(proxy, entry, mappedEntry, store);
					if (val)
						for (int32 i = 0; i < mappedEntry->fCount; i++) {
							swappedValue.value = B_BENDIAN_TO_HOST_INT32(*val);
							printf("%sdata[%li]: 0x%lx (%li, \'%.4s\')\n",
								i > 0 ? spaces + sl - offset : "", i,
								*val, *val, swappedValue.string);
							val++;
						}
					break;
				}
				case B_INT64_TYPE: {
					int64 *val = (int64*)da_start_of_data(proxy, entry, mappedEntry, store);
					if (val)
						for (int32 i = 0; i < mappedEntry->fCount; i++) {
							swappedValue.value = B_BENDIAN_TO_HOST_INT64(*val);
							printf("%sdata[%li]: 0x%Lx (%Ld, \'%.8s\')\n",
								i > 0 ? spaces + sl - offset : "", i,
								*val, *val, swappedValue.string);
							val++;
						}
					break;
				}
				case B_FLOAT_TYPE: {
					float *val = (float*)da_start_of_data(proxy, entry, mappedEntry, store);
					if (val)
						for (int32 i = 0; i < mappedEntry->fCount; i++) {
							printf("%sdata[%ld]: %.4f\n",
								i > 0 ? spaces + sl - offset : "", i, *val);
							val++;
						}
					break;
				}
				case B_POINT_TYPE: {
					BPoint *val = (BPoint*)da_start_of_data(proxy, entry, mappedEntry, store);
					if (val)
						for (int32 i = 0; i < mappedEntry->fCount; i++) {
							printf("%sdata[%ld]: ",
								i > 0 ? spaces + sl - offset : "", i);
							val++->PrintToStream();
						}
					break;
				}
				case B_RECT_TYPE: {
					BRect *val = (BRect*) da_start_of_data(proxy, entry, mappedEntry, store);
					if (val)
						for (int32 i = 0; i < mappedEntry->fCount; i++) {
							printf("%sdata[%ld]: ",
								i > 0 ? spaces + sl - offset : "", i);
							val++->PrintToStream();
						}
					break;
				}
				default:
					printf("\n");
			}

			entry = convert(mappedEntry->fNext);
			free(newEntry);
		}

		free(p);
	}
	else
		puts("Insufficient memory");
	
	return B_OK;
} // DumpVariable
