/*****************************************************************************
//
//	File:			3dModel.h
//
//	Description:	Generic class to describe the shape of a 3d object.
//
//	Copyright 1997, Be Incorporated
//
// The 3dKit is a fully object-oriented library, going from low-level 3d
// engine to high-level 3d API. The whole system is decomposed in functional
// blocks, that can include both high-level and low-level API. To allow all
// those classes to communicate smoothly and efficiently, most of their datas
// and methods are public. That can introduce some confusion in the sense that
// reading the headers will not allow developer to differenciate API levels
// by their protection only. That's why some comments were added in the key
// classes of the 3dKit to help you recognize which API you should use
// depending of the level of usage you want.
//***************************************************************************/

#ifndef _3D_MODEL_H
#define _3D_MODEL_H

#include "3dDefs.h"
#include "3dLighter.h"
#include "3dSupport.h"

/**************************************
// LOW-LEVEL API
/*************************************/

/* Internal use only */
enum {
	B_3D_RENDER_BACKS	= 0x00010000
};

class B3dLensImage;
class B3dSharedState;

typedef struct {
	float       radius;
	B3dVector   min;
	B3dVector   max;
} B3dSteric;

/**************************************
// B3dModel.
/*************************************/

class B3dModel
{

/*************************************
// LOW-LEVEL API                    */

	public:

		ulong			m_referenceCount;
		BArray<B3dVector>	m_points;
		BArray<B3dVector>	m_norms;
		B3dSteric			m_steric;
	
						B3dModel(	long numPoints,
								B3dVector *points,
								uint32 creationFlags = 0);
virtual					~B3dModel();
virtual	void				*Sort(	B3dLensImage *lensImage,
								uint32 status,
								B3dSharedState *buf);
};

#endif
