/***************************************************
**
**	File: wView.h
**	Description: 3d view constructor.
**	Copyright 1997, Be Incorporated
**
***************************************************/

#pragma once

#ifndef _W_VIEW_H
#define _W_VIEW_H

extern BBitmap *LoadTiff(char *filename);

#include <3dView.h>
#include <3dCube.h>
#include <3dBitmap.h>
#include <3dChannelServer.h>
#include <3dSphere.h>
#include <3dOffView.h>
#include <3dStdLinks.h>
#include <3dAmbientLight.h>
#include <3dParallelLight.h>

#include "wLink.h"

class wView : public B3dView {
public:
	B3dLight			*Light;
	B3dFaceBody		*myBody, *sndBody, *trdBody;
	B3dFaceBody		*vrmlBody,*teapot;
	B3dChannel		*pict;
	B3dChannel		*channel[2];
	B3dOffView		*offView;
	BList			objects;

	wView(BRect frame, char *name);
	~wView();
	virtual void AttachedToWindow(void);
	virtual void MessageReceived(BMessage *msg);
};


#endif












