/*****************************************************************************
//
//	File:			3dSphere.h
//
//	Description:	Simplified representation of a sphere using N faces.
//
//	Copyright 1997, Be Incorporated
//
// The 3dKit is a fully object-oriented library, going from low-level 3d
// engine to high-level 3d API. The whole system is decomposed in functional
// blocks, that can include both high-level and low-level API. To allow all
// those classes to communicate smoothly and efficiently, most of their datas
// and methods are public. That can introduce some confusion in the sense that
// reading the headers will not allow developer to differenciate API levels
// by their protection only. That's why some comments were added in the key
// classes of the 3dKit to help you recognize which API you should use
// depending of the level of usage you want.
//***************************************************************************/

#ifndef _3D_SPHERE_H
#define _3D_SPHERE_H

#include <unistd.h>

#ifndef _3D_FACE_H 
#include "3dFace.h"
#endif

/**************************************
// B3dSphere.
/*************************************/

class B3dSphere : public B3dFaceBody {

/*************************************
// HIGH-LEVEL API                   */

	public:
	
	B3dSphere(	char			*name,
				B3dWorld        *world,
				B3dVector		*size,
				uint32		faceCount);
	/* Create a sphere named 'name' of approximately 'faceCount'
	   triangles, inscribed within a box of size 'size', in the
	   universe 'uni'. */
	virtual ~B3dSphere();
	
	private:
	
	static B3dFaceModelDesc *BuildModel(B3dVector *size, uint32 faceCount);
};

#endif

