/*****************************************************************************
//
//	File:			3dLightProc.h
//
//	Description:	Generic class for light processing.
//
//	Copyright 1997, Be Incorporated
//
//***************************************************************************/

#ifndef _3D_LIGHT_PROC_H
#define _3D_LIGHT_PROC_H

#ifndef _3D_DEFS_H 
#include "3dDefs.h"
#endif
#ifndef _3D_AMBIENT_LIGHT_H 
#include "3dAmbientLight.h"
#endif
#ifndef _3D_PARALLEL_LIGHT_H 
#include "3dParallelLight.h"
#endif
#ifndef _3D_RADIAL_LIGHT_H 
#include "3dRadialLight.h"
#endif

class B3dLensImage;

struct B3dLightInfo {
	int32		materialCount;
	RGBAColor		fColor;
	uint32		specColor;
	uint32		iColor;
	uint16		pointIndex;
	uint16		normIndex;
};

struct PNLD;
class B3dMaterial;

class B3dLightProc {

	public:

virtual	void		SetLightContext(	B3dMatrix *rotation,
								B3dVector *translation);
virtual	void		Light(			B3dLensImage *projDesc, 
								uint16 pt, uint16 norm,
								PNLD *pnld);
virtual	void		SetMaterial(		B3dMaterial *material);
};

#endif










