#include<stdio.h>

unsigned get_word_num(FILE *IF)
{
     long pre_pos,pos;
     unsigned word_num;
     char ch;

     pre_pos=ftell(IF);
     fseek(IF,-1L,2);

     pos=ftell(IF);
     for(;;)
      { ch=fgetc(IF);
        if(isdigit(ch))
           break;
        pos--; 
        fseek(IF,pos,0); } 

     for(;;)
      { ch=fgetc(IF);
        if(ch=='\n')
            break;
        pos--; 
        fseek(IF,pos,0); }

     fscanf(IF,"%d",&word_num);
     fseek(IF,pre_pos,0);

     return word_num;
 }

typedef struct {
     char word[30];
     long  pos;
    } INDEX;

INDEX temp;

/* sort by INSERTION SORT */
void sort_index(unsigned num,INDEX *index)
{
    unsigned i,j;

    for(i=2;i<num;i++)
    {
      temp=index[i];
      j = i-1;
      while(strcmp(temp.word,index[j].word)<0)
        {   index[j+1]=index[j];
            j--; }
      index[j+1]=temp;
       }
}

int main(int argc,char *argv[])
{
    FILE *IF;
    char dict[255],temp[255],ch;
    long pos;
    unsigned word_num=0;
    char a[2]="`";
    INDEX *index;

    unsigned i,j;

    if(argc<2) {
    	fprintf(stderr,"usage:sortidx idxfile\n");
    	exit(-1);
    }
	IF = fopen(argv[1],"r");
	if(IF==NULL) {
    	fprintf(stderr,"can't open %s\n",argv[1]);
    	exit(-1);
	}

    word_num = get_word_num(IF);
    printf("total words = %d\n",word_num); 
    /* word_num = 31448; */
    word_num ++; /* for 1st dummy word */
    printf("required memory : %d \n", word_num * sizeof(INDEX) );
    index = (INDEX *) calloc(word_num,sizeof(INDEX));
    if(index == NULL)
       { fprintf(stderr,"Not enough memory!\n");
	 exit(-1);
	 }

    index[0].word[0]=1;
    index[0].word[1]='\0';
    index[0].pos = 0;
    for(i=1;i<word_num;i++)
       {
	 fscanf(IF,"%s %d",temp,&pos);
/*	 printf("%s %ld\n",temp,pos); */
	 strcpy(index[i].word,temp);
	 index[i].pos = pos;
/*	 printf("%s %ld\n",index[i].word,index[i].pos); */
	}
    fclose(IF);

    sort_index(word_num,index);

    IF = fopen(argv[1],"w");
    if(IF == NULL)
      {
	fprintf(stderr,"No such %s file\n",argv[1]);
        exit(-1);
      }
    for(i=0;i<word_num;i++)
       fprintf(IF,"%s %d\n",index[i].word,index[i].pos);
    fprintf(IF,"%d",word_num);
    fclose(IF);
    free(index);
return 0;
}
